/*
 * Decompiled with CFR 0.152.
 */
package de.tesis.dynaware.grapheditor.utils;

import de.tesis.dynaware.grapheditor.GConnectorSkin;
import de.tesis.dynaware.grapheditor.GJointSkin;
import de.tesis.dynaware.grapheditor.GNodeSkin;
import de.tesis.dynaware.grapheditor.SkinLookup;
import de.tesis.dynaware.grapheditor.model.GConnectable;
import de.tesis.dynaware.grapheditor.model.GConnection;
import de.tesis.dynaware.grapheditor.model.GConnector;
import de.tesis.dynaware.grapheditor.model.GJoint;
import de.tesis.dynaware.grapheditor.model.GNode;
import de.tesis.dynaware.grapheditor.utils.DraggableBox;
import java.util.ArrayList;
import java.util.List;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;

public class GeometryUtils {
    private static final double HALF_A_PIXEL = 0.5;

    public static Point2D getConnectorPosition(GConnector connector, SkinLookup skinLookup) {
        GConnectorSkin connectorSkin = skinLookup.lookupConnector(connector);
        GConnectable parent = connector.getParent();
        if (parent instanceof GNode) {
            GNodeSkin nodeSkin = skinLookup.lookupNode((GNode)parent);
            nodeSkin.layoutConnectors();
            nodeSkin.getConnectorPosition(skinLookup.lookupConnector(connector));
            double nodeX = nodeSkin.getRoot().getLayoutX();
            double nodeY = nodeSkin.getRoot().getLayoutY();
            double connectorX = nodeSkin.getConnectorPosition(connectorSkin).getX();
            double connectorY = nodeSkin.getConnectorPosition(connectorSkin).getY();
            return new Point2D(GeometryUtils.moveOnPixel(nodeX + connectorX), GeometryUtils.moveOnPixel(nodeY + connectorY));
        }
        return null;
    }

    public static Point2D getCursorPosition(MouseEvent event, Node node) {
        double sceneX = event.getSceneX();
        double sceneY = event.getSceneY();
        double containerSceneX = node.localToScene(0.0, 0.0).getX();
        double containerSceneY = node.localToScene(0.0, 0.0).getY();
        return new Point2D(sceneX - containerSceneX, sceneY - containerSceneY);
    }

    public static List<Point2D> getJointPositions(List<GJointSkin> jointSkins) {
        ArrayList<Point2D> jointPositions = new ArrayList<Point2D>();
        for (GJointSkin jointSkin : jointSkins) {
            DraggableBox region = jointSkin.getRoot();
            double x = region.getLayoutX() + jointSkin.getWidth() / 2.0;
            double y = region.getLayoutY() + jointSkin.getHeight() / 2.0;
            jointPositions.add(new Point2D(x, y));
        }
        return jointPositions;
    }

    public static List<Point2D> getJointPositions(GConnection connection, SkinLookup skinLookup) {
        List<GJointSkin> jointSkins = GeometryUtils.getJointSkins(connection, skinLookup);
        return GeometryUtils.getJointPositions(jointSkins);
    }

    public static List<Point2D> getJointPositions(GConnection connection) {
        ArrayList<Point2D> jointPositions = new ArrayList<Point2D>();
        for (GJoint joint : connection.getJoints()) {
            jointPositions.add(new Point2D(joint.getX(), joint.getY()));
        }
        return jointPositions;
    }

    public static List<GJointSkin> getJointSkins(GConnection connection, SkinLookup skinLookup) {
        ArrayList<GJointSkin> jointSkins = new ArrayList<GJointSkin>();
        for (GJoint joint : connection.getJoints()) {
            jointSkins.add(skinLookup.lookupJoint(joint));
        }
        return jointSkins;
    }

    public static double moveOnPixel(double position) {
        return Math.ceil(position);
    }

    public static double moveOffPixel(double position) {
        return Math.ceil(position) - 0.5;
    }

    public static boolean checkInRange(double firstValue, double secondValue, double position) {
        if (secondValue >= firstValue) {
            return firstValue <= position && position <= secondValue;
        }
        return secondValue <= position && position <= firstValue;
    }

    public static boolean checkIntersection(Point2D a, Point2D b, Point2D c, Point2D d) {
        if (!(c.getX() > a.getX() && c.getX() < b.getX() || c.getX() > b.getX() && c.getX() < a.getX())) {
            return false;
        }
        return a.getY() > c.getY() && a.getY() < d.getY() || a.getY() > d.getY() && a.getY() < c.getY();
    }
}

