/*
 * Decompiled with CFR 0.152.
 */
package de.tesis.dynaware.grapheditor;

import de.tesis.dynaware.grapheditor.GraphEditor;
import de.tesis.dynaware.grapheditor.SkinLookup;
import de.tesis.dynaware.grapheditor.model.GModel;
import de.tesis.dynaware.grapheditor.window.AutoScrollingWindow;
import de.tesis.dynaware.grapheditor.window.GraphEditorMinimap;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;

public class GraphEditorContainer
extends AutoScrollingWindow {
    private static final double MINIMAP_WIDTH = 250.0;
    private static final double MINIMAP_RIGHT_INDENT = 10.0;
    private static final double MINIMAP_TOP_INDENT = 10.0;
    private final GraphEditorMinimap minimap = new GraphEditorMinimap(250.0);
    private GraphEditor graphEditor;
    private ChangeListener<GModel> modelChangeListener;

    public GraphEditorContainer() {
        this.initializeMinimap();
        this.createModelChangeListener();
    }

    public void setGraphEditor(GraphEditor graphEditor) {
        if (this.graphEditor != null) {
            this.graphEditor.modelProperty().removeListener(this.modelChangeListener);
            this.graphEditor.getView().setOnScroll(null);
        }
        this.graphEditor = graphEditor;
        if (graphEditor != null) {
            graphEditor.modelProperty().addListener(this.modelChangeListener);
            Region view = graphEditor.getView();
            GModel model = graphEditor.getModel();
            SkinLookup skinLookup = graphEditor.getSkinLookup();
            if (model != null) {
                view.resize(model.getContentWidth(), model.getContentHeight());
            }
            this.setContent(view);
            this.minimap.setContent(view);
            this.minimap.setModel(model);
            this.minimap.setSkinLookup(skinLookup);
            view.toBack();
            view.setOnScroll(event -> this.panBy(-event.getDeltaX(), -event.getDeltaY()));
        } else {
            this.minimap.setContent(null);
            this.minimap.setModel(null);
        }
    }

    public Pane getMinimap() {
        return this.minimap;
    }

    private void initializeMinimap() {
        this.getChildren().add((Object)this.minimap);
        this.minimap.setWindow(this);
        this.minimap.layoutXProperty().bind((ObservableValue)this.widthProperty().subtract(260.0));
        this.minimap.setLayoutY(10.0);
        this.minimap.setVisible(false);
    }

    private void createModelChangeListener() {
        this.modelChangeListener = (observable, oldValue, newValue) -> {
            if (newValue == null || newValue != null && !newValue.equals(oldValue)) {
                this.graphEditor.getView().resize(newValue.getContentWidth(), newValue.getContentHeight());
                this.checkWindowBounds();
                this.minimap.setModel((GModel)newValue);
            }
        };
    }
}

