/*
 * Decompiled with CFR 0.152.
 */
package de.tesis.dynaware.grapheditor.window;

import de.tesis.dynaware.grapheditor.GNodeSkin;
import de.tesis.dynaware.grapheditor.SkinLookup;
import de.tesis.dynaware.grapheditor.model.GNode;
import javafx.beans.value.ChangeListener;
import javafx.css.PseudoClass;
import javafx.scene.shape.Rectangle;

public class MinimapNode
extends Rectangle {
    private static final String STYLE_CLASS = "minimap-node";
    private static final PseudoClass PSEUDO_CLASS_SELECTED = PseudoClass.getPseudoClass((String)"selected");
    private final ChangeListener<? super Boolean> selectionListener = (v, o, n) -> this.setSelected((boolean)n);

    public MinimapNode(GNode node, SkinLookup skinLookup) {
        this.getStyleClass().setAll((Object[])new String[]{STYLE_CLASS});
        if (skinLookup != null) {
            GNodeSkin nodeSkin = skinLookup.lookupNode(node);
            if (nodeSkin != null) {
                this.setSelected(nodeSkin.isSelected());
                nodeSkin.selectedProperty().addListener(this.selectionListener);
            } else {
                this.setSelected(false);
            }
        } else {
            this.setSelected(false);
        }
    }

    private void setSelected(boolean selected) {
        this.pseudoClassStateChanged(PSEUDO_CLASS_SELECTED, selected);
    }
}

