/*
 * Decompiled with CFR 0.152.
 */
package de.tesis.dynaware.grapheditor.window;

import de.tesis.dynaware.grapheditor.SkinLookup;
import de.tesis.dynaware.grapheditor.model.GModel;
import de.tesis.dynaware.grapheditor.utils.FloorBinding;
import de.tesis.dynaware.grapheditor.window.MinimapNodeGroup;
import de.tesis.dynaware.grapheditor.window.PanningWindowMinimap;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.layout.Region;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;

public class GraphEditorMinimap
extends PanningWindowMinimap {
    private static final double INITIAL_ASPECT_RATIO = 0.75;
    private final MinimapNodeGroup minimapNodeGroup = new MinimapNodeGroup();
    private GModel model;
    private CommandStackListener modelChangeListener;
    private DoubleBinding contentRatio;
    private DoubleBinding widthBeforePadding;
    private DoubleBinding heightBeforePadding;

    public GraphEditorMinimap(double width) {
        this.setMinWidth(width);
        this.setPrefWidth(width);
        this.setMaxWidth(width);
        this.setMinHeight(width * 0.75);
        this.setPrefHeight(width * 0.75);
        this.setMaxHeight(width * 0.75);
        this.autosize();
        this.setContentRepresentation(this.minimapNodeGroup);
        this.createModelChangeListener();
    }

    public void setSkinLookup(SkinLookup skinLookup) {
        this.minimapNodeGroup.setSkinLookup(skinLookup);
    }

    @Override
    public void setContent(Region content) {
        super.setContent(content);
        this.bindAspectRatioToContent(content);
    }

    public void setModel(GModel model) {
        EditingDomain domain;
        if (this.model != null && (domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)this.model)) != null) {
            domain.getCommandStack().removeCommandStackListener(this.modelChangeListener);
        }
        this.model = model;
        this.minimapNodeGroup.setModel(model);
        this.minimapNodeGroup.draw(this.calculateScaleFactor());
        if (model != null && (domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)model)) != null) {
            domain.getCommandStack().addCommandStackListener(this.modelChangeListener);
        }
    }

    private void bindAspectRatioToContent(Region content) {
        this.contentRatio = content.heightProperty().divide((ObservableNumberValue)content.widthProperty());
        this.widthBeforePadding = this.widthProperty().subtract(10.0);
        this.heightBeforePadding = this.widthBeforePadding.multiply((ObservableNumberValue)this.contentRatio);
        FloorBinding flooredHeight = new FloorBinding(this.heightBeforePadding);
        this.minHeightProperty().bind((ObservableValue)flooredHeight.add(10.0));
        this.prefHeightProperty().bind((ObservableValue)flooredHeight.add(10.0));
        this.maxHeightProperty().bind((ObservableValue)flooredHeight.add(10.0));
    }

    private void createModelChangeListener() {
        this.modelChangeListener = event -> {
            if (this.isVisible()) {
                this.minimapNodeGroup.draw(this.calculateScaleFactor());
            }
        };
    }
}

