/*
 * Decompiled with CFR 0.152.
 */
package de.tesis.dynaware.grapheditor.utils;

import java.util.HashMap;
import java.util.Map;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;

public class GraphEditorProperties {
    public static final double DEFAULT_MAX_WIDTH = Double.MAX_VALUE;
    public static final double DEFAULT_MAX_HEIGHT = Double.MAX_VALUE;
    private static final double DEFAULT_BOUND_VALUE = 15.0;
    private static final double DEFAULT_GRID_SPACING = 12.0;
    private final boolean northBoundActive = true;
    private final boolean westBoundActive = true;
    private boolean southBoundActive = true;
    private boolean eastBoundActive = true;
    private double northBoundValue = 15.0;
    private double southBoundValue = 15.0;
    private double eastBoundValue = 15.0;
    private double westBoundValue = 15.0;
    private final BooleanProperty gridVisibleProperty = new SimpleBooleanProperty();
    private final BooleanProperty snapToGridProperty = new SimpleBooleanProperty();
    private final DoubleProperty gridSpacingProperty = new SimpleDoubleProperty(12.0);
    private final Map<String, String> customProperties = new HashMap<String, String>();

    public GraphEditorProperties() {
    }

    public GraphEditorProperties(GraphEditorProperties editorProperties) {
        this.southBoundActive = editorProperties.isSouthBoundActive();
        this.eastBoundActive = editorProperties.isSouthBoundActive();
        this.northBoundValue = editorProperties.getNorthBoundValue();
        this.southBoundValue = editorProperties.getSouthBoundValue();
        this.eastBoundValue = editorProperties.getEastBoundValue();
        this.westBoundValue = editorProperties.getWestBoundValue();
        this.gridVisibleProperty.set(editorProperties.isGridVisible());
        this.snapToGridProperty.set(editorProperties.isSnapToGridOn());
        this.gridSpacingProperty.set(editorProperties.getGridSpacing());
    }

    public boolean isNorthBoundActive() {
        return true;
    }

    public boolean isSouthBoundActive() {
        return this.southBoundActive;
    }

    public void setSouthBound(boolean southBound) {
        this.southBoundActive = southBound;
    }

    public boolean isEastBoundActive() {
        return this.eastBoundActive;
    }

    public void setEastBound(boolean eastBound) {
        this.eastBoundActive = eastBound;
    }

    public boolean isWestBoundActive() {
        return true;
    }

    public double getNorthBoundValue() {
        return this.northBoundValue;
    }

    public void setNorthBoundValue(double northBoundValue) {
        this.northBoundValue = northBoundValue;
    }

    public double getSouthBoundValue() {
        return this.southBoundValue;
    }

    public void setSouthBoundValue(double southBoundValue) {
        this.southBoundValue = southBoundValue;
    }

    public double getEastBoundValue() {
        return this.eastBoundValue;
    }

    public void setEastBoundValue(double eastBoundValue) {
        this.eastBoundValue = eastBoundValue;
    }

    public double getWestBoundValue() {
        return this.westBoundValue;
    }

    public void setWestBoundValue(double westBoundValue) {
        this.westBoundValue = westBoundValue;
    }

    public boolean isGridVisible() {
        return this.gridVisibleProperty.get();
    }

    public void setGridVisible(boolean gridVisible) {
        this.gridVisibleProperty.set(gridVisible);
    }

    public BooleanProperty gridVisibleProperty() {
        return this.gridVisibleProperty;
    }

    public boolean isSnapToGridOn() {
        return this.snapToGridProperty.get();
    }

    public void setSnapToGrid(boolean snapToGrid) {
        this.snapToGridProperty.set(snapToGrid);
    }

    public BooleanProperty snapToGridProperty() {
        return this.snapToGridProperty;
    }

    public double getGridSpacing() {
        return this.gridSpacingProperty.get();
    }

    public void setGridSpacing(double gridSpacing) {
        this.gridSpacingProperty.set(gridSpacing);
    }

    public DoubleProperty gridSpacingProperty() {
        return this.gridSpacingProperty;
    }

    public Map<String, String> getCustomProperties() {
        return this.customProperties;
    }
}

