/*
 * Decompiled with CFR 0.152.
 */
package de.tesis.dynaware.grapheditor.utils;

import de.tesis.dynaware.grapheditor.utils.DraggableBox;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.Cursor;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;

public class ResizableBox
extends DraggableBox {
    private static final int DEFAULT_RESIZE_BORDER_TOLERANCE = 8;
    private final BooleanProperty resizeEnabledNorthProperty = new SimpleBooleanProperty(true);
    private final BooleanProperty resizeEnabledSouthProperty = new SimpleBooleanProperty(true);
    private final BooleanProperty resizeEnabledEastProperty = new SimpleBooleanProperty(true);
    private final BooleanProperty resizeEnabledWestProperty = new SimpleBooleanProperty(true);
    private int resizeBorderTolerance = 8;
    private double lastWidth;
    private double lastHeight;
    private RectangleMouseRegion lastMouseRegion;
    private boolean mouseInPositionForResize;

    public ResizableBox() {
        this.addEventHandler(MouseEvent.MOUSE_ENTERED, this::processMousePosition);
        this.addEventHandler(MouseEvent.MOUSE_MOVED, this::processMousePosition);
        this.addEventHandler(MouseEvent.MOUSE_EXITED, event -> {
            if (!event.isPrimaryButtonDown()) {
                this.setCursor(null);
            }
        });
    }

    public boolean isResizeEnabledNorth() {
        return this.resizeEnabledNorthProperty.get();
    }

    public void setResizeEnabledNorth(boolean resizeEnabledNorth) {
        this.resizeEnabledNorthProperty.set(resizeEnabledNorth);
    }

    public boolean isResizeEnabledSouth() {
        return this.resizeEnabledSouthProperty.get();
    }

    public void setResizeEnabledSouth(boolean resizeEnabledSouth) {
        this.resizeEnabledSouthProperty.set(resizeEnabledSouth);
    }

    public boolean isResizeEnabledEast() {
        return this.resizeEnabledEastProperty.get();
    }

    public void setResizeEnabledEast(boolean resizeEnabledEast) {
        this.resizeEnabledEastProperty.set(resizeEnabledEast);
    }

    public boolean isResizeEnabledWest() {
        return this.resizeEnabledWestProperty.get();
    }

    public void setResizeEnabledWest(boolean resizeEnabledWest) {
        this.resizeEnabledWestProperty.set(resizeEnabledWest);
    }

    public int getResizeBorderTolerance() {
        return this.resizeBorderTolerance;
    }

    public void setResizeBorderTolerance(int resizeBorderTolerance) {
        this.resizeBorderTolerance = resizeBorderTolerance;
    }

    public boolean isMouseInPositionForResize() {
        return this.mouseInPositionForResize;
    }

    @Override
    protected void handleMousePressed(MouseEvent event) {
        super.handleMousePressed(event);
        if (!(this.getParent() instanceof Region)) {
            return;
        }
        if (!event.getButton().equals((Object)MouseButton.PRIMARY)) {
            this.setCursor(null);
            return;
        }
        this.storeClickValuesForResize(event.getX(), event.getY());
    }

    @Override
    protected void handleMouseDragged(MouseEvent event) {
        if (!(this.getParent() instanceof Region)) {
            return;
        }
        if (!event.getButton().equals((Object)MouseButton.PRIMARY)) {
            this.setCursor(null);
            return;
        }
        if (!this.dragActive) {
            this.storeClickValuesForDrag(event.getSceneX(), event.getSceneY());
            this.storeClickValuesForResize(event.getX(), event.getY());
        }
        if (this.lastMouseRegion.equals((Object)RectangleMouseRegion.INSIDE)) {
            super.handleMouseDragged(event);
        } else if (!this.lastMouseRegion.equals((Object)RectangleMouseRegion.OUTSIDE)) {
            this.handleResize(event.getSceneX(), event.getSceneY());
        }
        this.dragActive = true;
        event.consume();
    }

    @Override
    protected void handleMouseReleased(MouseEvent event) {
        super.handleMouseReleased(event);
        if (event.getButton().equals((Object)MouseButton.PRIMARY)) {
            this.processMousePosition(event);
        }
    }

    private void processMousePosition(MouseEvent event) {
        if (event.isPrimaryButtonDown()) {
            return;
        }
        RectangleMouseRegion mouseRegion = this.getMouseRegion(event.getX(), event.getY());
        this.mouseInPositionForResize = !mouseRegion.equals((Object)RectangleMouseRegion.INSIDE);
        this.updateCursor(mouseRegion);
    }

    private void storeClickValuesForResize(double x, double y) {
        this.lastWidth = this.getWidth();
        this.lastHeight = this.getHeight();
        this.lastMouseRegion = this.getMouseRegion(x, y);
    }

    private void handleResize(double x, double y) {
        switch (this.lastMouseRegion) {
            case NORTHEAST: {
                this.handleResizeNorth(y);
                this.handleResizeEast(x);
                break;
            }
            case NORTHWEST: {
                this.handleResizeNorth(y);
                this.handleResizeWest(x);
                break;
            }
            case SOUTHEAST: {
                this.handleResizeSouth(y);
                this.handleResizeEast(x);
                break;
            }
            case SOUTHWEST: {
                this.handleResizeSouth(y);
                this.handleResizeWest(x);
                break;
            }
            case NORTH: {
                this.handleResizeNorth(y);
                break;
            }
            case SOUTH: {
                this.handleResizeSouth(y);
                break;
            }
            case EAST: {
                this.handleResizeEast(x);
                break;
            }
            case WEST: {
                this.handleResizeWest(x);
                break;
            }
            case INSIDE: {
                break;
            }
        }
    }

    private void handleResizeNorth(double y) {
        double scaleFactor = this.getLocalToSceneTransform().getMyy();
        double yDragDistance = (y - this.lastMouseY) / scaleFactor;
        double minResizeHeight = Math.max(this.getMinHeight(), 0.0);
        double newLayoutY = this.lastLayoutY + yDragDistance;
        double newHeight = this.lastHeight - yDragDistance;
        if (this.editorProperties.isSnapToGridOn()) {
            double roundedLayoutY = this.roundToGridSpacing(newLayoutY) - 1.0;
            newHeight = newHeight - roundedLayoutY + newLayoutY;
            newLayoutY = roundedLayoutY;
        } else {
            double roundedLayoutY = Math.round(newLayoutY);
            newHeight = Math.round(newHeight - roundedLayoutY + newLayoutY);
            newLayoutY = roundedLayoutY;
        }
        if (this.editorProperties.isNorthBoundActive() && newLayoutY < this.editorProperties.getNorthBoundValue()) {
            newLayoutY = this.editorProperties.getNorthBoundValue();
            newHeight = this.lastLayoutY + this.lastHeight - this.editorProperties.getNorthBoundValue();
        } else if (newHeight < minResizeHeight) {
            newLayoutY = this.lastLayoutY + this.lastHeight - minResizeHeight;
            newHeight = minResizeHeight;
        }
        this.setLayoutY(newLayoutY);
        this.setHeight(newHeight);
    }

    private void handleResizeSouth(double y) {
        double scaleFactor = this.getLocalToSceneTransform().getMyy();
        double yDragDistance = (y - this.lastMouseY) / scaleFactor;
        double parentHeight = this.getParent().getLayoutBounds().getHeight();
        double maxParentHeight = this.editorProperties.isSouthBoundActive() ? parentHeight : this.absoluteMaxHeight;
        double minResizeHeight = Math.max(this.getMinHeight(), 0.0);
        double maxAvailableHeight = maxParentHeight - this.getLayoutY() - this.editorProperties.getSouthBoundValue();
        double newHeight = this.lastHeight + yDragDistance;
        newHeight = this.editorProperties.isSnapToGridOn() ? this.roundToGridSpacing(newHeight + this.lastLayoutY) - this.lastLayoutY : (double)Math.round(newHeight);
        if (newHeight > maxAvailableHeight) {
            newHeight = maxAvailableHeight;
        } else if (newHeight < minResizeHeight) {
            newHeight = minResizeHeight;
        }
        this.setHeight(newHeight);
    }

    private void handleResizeEast(double x) {
        double scaleFactor = this.getLocalToSceneTransform().getMxx();
        double xDragDistance = (x - this.lastMouseX) / scaleFactor;
        double parentWidth = this.getParent().getLayoutBounds().getWidth();
        double maxParentWidth = this.editorProperties.isEastBoundActive() ? parentWidth : this.absoluteMaxWidth;
        double minResizeWidth = Math.max(this.getMinWidth(), 0.0);
        double maxAvailableWidth = maxParentWidth - this.getLayoutX() - this.editorProperties.getEastBoundValue();
        double newWidth = this.lastWidth + xDragDistance;
        newWidth = this.editorProperties.isSnapToGridOn() ? this.roundToGridSpacing(newWidth + this.lastLayoutX) - this.lastLayoutX : (double)Math.round(newWidth);
        if (newWidth > maxAvailableWidth) {
            newWidth = maxAvailableWidth;
        } else if (newWidth < minResizeWidth) {
            newWidth = minResizeWidth;
        }
        this.setWidth(newWidth);
    }

    private void handleResizeWest(double x) {
        double scaleFactor = this.getLocalToSceneTransform().getMxx();
        double xDragDistance = (x - this.lastMouseX) / scaleFactor;
        double minResizeWidth = Math.max(this.getMinWidth(), 0.0);
        double newLayoutX = this.lastLayoutX + xDragDistance;
        double newWidth = this.lastWidth - xDragDistance;
        if (this.editorProperties.isSnapToGridOn()) {
            double roundedLayoutX = this.roundToGridSpacing(newLayoutX) - 1.0;
            newWidth = newWidth - roundedLayoutX + newLayoutX;
            newLayoutX = roundedLayoutX;
        } else {
            double roundedLayoutX = Math.round(newLayoutX);
            newWidth = Math.round(newWidth - roundedLayoutX + newLayoutX);
            newLayoutX = roundedLayoutX;
        }
        if (this.editorProperties.isWestBoundActive() && newLayoutX < this.editorProperties.getWestBoundValue()) {
            newLayoutX = this.editorProperties.getWestBoundValue();
            newWidth = this.lastLayoutX + this.lastWidth - this.editorProperties.getWestBoundValue();
        } else if (newWidth < minResizeWidth) {
            newLayoutX = this.lastLayoutX + this.lastWidth - minResizeWidth;
            newWidth = minResizeWidth;
        }
        this.setLayoutX(newLayoutX);
        this.setWidth(newWidth);
    }

    private RectangleMouseRegion getMouseRegion(double x, double y) {
        boolean isWest;
        double width = this.getWidth();
        double height = this.getHeight();
        if (x < 0.0 || y < 0.0 || x > width || y > height) {
            return RectangleMouseRegion.OUTSIDE;
        }
        boolean isNorth = y < (double)this.resizeBorderTolerance;
        boolean isSouth = y > height - (double)this.resizeBorderTolerance;
        boolean isEast = x > width - (double)this.resizeBorderTolerance;
        boolean bl = isWest = x < (double)this.resizeBorderTolerance;
        if (isNorth && isEast) {
            return RectangleMouseRegion.NORTHEAST;
        }
        if (isNorth && isWest) {
            return RectangleMouseRegion.NORTHWEST;
        }
        if (isSouth && isEast) {
            return RectangleMouseRegion.SOUTHEAST;
        }
        if (isSouth && isWest) {
            return RectangleMouseRegion.SOUTHWEST;
        }
        if (isNorth) {
            return RectangleMouseRegion.NORTH;
        }
        if (isSouth) {
            return RectangleMouseRegion.SOUTH;
        }
        if (isEast) {
            return RectangleMouseRegion.EAST;
        }
        if (isWest) {
            return RectangleMouseRegion.WEST;
        }
        return RectangleMouseRegion.INSIDE;
    }

    private void updateCursor(RectangleMouseRegion mouseRegion) {
        switch (mouseRegion) {
            case NORTHEAST: {
                this.setCursor(Cursor.NE_RESIZE);
                break;
            }
            case NORTHWEST: {
                this.setCursor(Cursor.NW_RESIZE);
                break;
            }
            case SOUTHEAST: {
                this.setCursor(Cursor.SE_RESIZE);
                break;
            }
            case SOUTHWEST: {
                this.setCursor(Cursor.SW_RESIZE);
                break;
            }
            case NORTH: {
                this.setCursor(Cursor.N_RESIZE);
                break;
            }
            case SOUTH: {
                this.setCursor(Cursor.S_RESIZE);
                break;
            }
            case EAST: {
                this.setCursor(Cursor.E_RESIZE);
                break;
            }
            case WEST: {
                this.setCursor(Cursor.W_RESIZE);
                break;
            }
            case INSIDE: {
                this.setCursor(null);
                break;
            }
            case OUTSIDE: {
                this.setCursor(null);
            }
        }
    }

    private static enum RectangleMouseRegion {
        NORTH,
        NORTHEAST,
        EAST,
        SOUTHEAST,
        SOUTH,
        SOUTHWEST,
        WEST,
        NORTHWEST,
        INSIDE,
        OUTSIDE;

    }
}

