/*
 * Decompiled with CFR 0.152.
 */
package de.tesis.dynaware.grapheditor.window;

import de.tesis.dynaware.grapheditor.window.WindowPosition;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Point2D;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.scene.shape.Rectangle;

public class PanningWindow
extends Region {
    private final Rectangle clip = new Rectangle();
    private Region content;
    private final DoubleProperty windowXProperty = new SimpleDoubleProperty();
    private final DoubleProperty windowYProperty = new SimpleDoubleProperty();
    protected EventHandler<MouseEvent> mousePressedHandler;
    protected EventHandler<MouseEvent> mouseDraggedHandler;
    protected EventHandler<MouseEvent> mouseReleasedHandler;
    private Point2D clickPosition;
    private double windowXAtClick;
    private double windowYAtClick;
    private boolean panningGestureActive;
    private boolean cacheWhilePanning = true;

    public PanningWindow() {
        this.clip.widthProperty().bind((ObservableValue)this.widthProperty());
        this.clip.heightProperty().bind((ObservableValue)this.heightProperty());
        this.setClip((Node)this.clip);
        ChangeListener windowSizeChangeListener = (observableValue, oldValue, newValue) -> this.checkWindowBounds();
        this.widthProperty().addListener(windowSizeChangeListener);
        this.heightProperty().addListener(windowSizeChangeListener);
    }

    public void panTo(double x, double y) {
        this.windowXProperty.set(x);
        this.windowYProperty.set(y);
        this.checkWindowBounds();
    }

    public void panBy(double x, double y) {
        this.windowXProperty.set(this.windowXProperty.get() + x);
        this.windowYProperty.set(this.windowYProperty.get() + y);
        this.checkWindowBounds();
    }

    public void panTo(WindowPosition position) {
        switch (position) {
            case TOP_CENTER: {
                this.windowXProperty.set((this.content.getWidth() - this.getWidth()) / 2.0);
                this.windowYProperty.set(0.0);
                break;
            }
            case CENTER: {
                this.windowXProperty.set((this.content.getWidth() - this.getWidth()) / 2.0);
                this.windowYProperty.set((this.content.getHeight() - this.getHeight()) / 2.0);
            }
        }
        this.checkWindowBounds();
    }

    public DoubleProperty windowXProperty() {
        return this.windowXProperty;
    }

    public DoubleProperty windowYProperty() {
        return this.windowYProperty;
    }

    public void checkWindowBounds() {
        if (this.content != null) {
            if (this.windowXProperty.get() < 0.0) {
                this.windowXProperty.set(0.0);
            }
            if (this.windowYProperty.get() < 0.0) {
                this.windowYProperty.set(0.0);
            }
            double zoomFactor = this.content.getLocalToSceneTransform().getMxx();
            double maxX = zoomFactor * this.content.getWidth() - this.getWidth();
            double maxY = zoomFactor * this.content.getHeight() - this.getHeight();
            if (this.windowXProperty.get() > maxX) {
                this.windowXProperty.set(maxX);
            }
            if (this.windowYProperty.get() > maxY) {
                this.windowYProperty.set(maxY);
            }
            this.windowXProperty.set((double)Math.round(this.windowXProperty.get()));
            this.windowYProperty.set((double)Math.round(this.windowYProperty.get()));
        }
    }

    public boolean isCacheWhilePanning() {
        return this.cacheWhilePanning;
    }

    public void setCacheWhilePanning(boolean cacheWhilePanning) {
        this.cacheWhilePanning = cacheWhilePanning;
    }

    protected Region getContent() {
        return this.content;
    }

    protected void setContent(Region content) {
        if (this.content != null) {
            this.removeMouseHandlersFromContent();
            this.getChildren().remove((Object)this.content);
            this.content.layoutXProperty().unbind();
            this.content.layoutYProperty().unbind();
        }
        this.content = content;
        if (content != null) {
            content.setManaged(false);
            content.cacheHintProperty().set((Object)CacheHint.SPEED);
            this.getChildren().add((Object)content);
            content.layoutXProperty().bind((ObservableValue)this.windowXProperty.multiply(-1));
            content.layoutYProperty().bind((ObservableValue)this.windowYProperty.multiply(-1));
            this.addMouseHandlersToContent();
        }
    }

    private void addMouseHandlersToContent() {
        this.mousePressedHandler = event -> {
            if (!event.getButton().equals((Object)MouseButton.SECONDARY)) {
                return;
            }
            if (this.cacheWhilePanning) {
                this.content.setCache(true);
            }
            this.panningGestureActive = true;
            this.clickPosition = new Point2D(event.getSceneX(), event.getSceneY());
            this.windowXAtClick = this.windowXProperty().get();
            this.windowYAtClick = this.windowYProperty().get();
        };
        this.mouseDraggedHandler = event -> {
            if (!this.panningGestureActive) {
                return;
            }
            Point2D currentPosition = new Point2D(event.getSceneX(), event.getSceneY());
            double deltaX = currentPosition.getX() - this.clickPosition.getX();
            double deltaY = currentPosition.getY() - this.clickPosition.getY();
            double newWindowX = this.windowXAtClick - deltaX;
            double newWindowY = this.windowYAtClick - deltaY;
            this.panTo(newWindowX, newWindowY);
        };
        this.mouseReleasedHandler = event -> {
            if (!event.getButton().equals((Object)MouseButton.SECONDARY)) {
                return;
            }
            if (this.cacheWhilePanning) {
                this.content.setCache(false);
            }
            this.panningGestureActive = false;
        };
        this.content.addEventHandler(MouseEvent.MOUSE_PRESSED, this.mousePressedHandler);
        this.content.addEventHandler(MouseEvent.MOUSE_DRAGGED, this.mouseDraggedHandler);
        this.content.addEventHandler(MouseEvent.MOUSE_RELEASED, this.mouseReleasedHandler);
    }

    private void removeMouseHandlersFromContent() {
        if (this.mousePressedHandler != null) {
            this.content.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.mousePressedHandler);
        }
        if (this.mouseDraggedHandler != null) {
            this.content.removeEventHandler(MouseEvent.MOUSE_DRAGGED, this.mouseDraggedHandler);
        }
        if (this.mouseReleasedHandler != null) {
            this.content.removeEventHandler(MouseEvent.MOUSE_RELEASED, this.mouseReleasedHandler);
        }
    }
}

