/*
 * Decompiled with CFR 0.152.
 */
package de.tesis.dynaware.grapheditor.window;

import de.tesis.dynaware.grapheditor.utils.DraggableBox;
import de.tesis.dynaware.grapheditor.utils.GraphEditorProperties;
import javafx.scene.layout.Region;

public class MinimapLocator
extends DraggableBox {
    private static final String STYLE_CLASS_LOCATOR = "minimap-locator";
    private final double minimapPadding;

    public MinimapLocator(double minimapPadding) {
        this.minimapPadding = minimapPadding;
        this.getBorderRectangle().getStyleClass().addAll((Object[])new String[]{STYLE_CLASS_LOCATOR});
        this.getBackgroundRectangle().setVisible(false);
        GraphEditorProperties locatorProperties = new GraphEditorProperties();
        locatorProperties.setNorthBoundValue(minimapPadding);
        locatorProperties.setSouthBoundValue(minimapPadding);
        locatorProperties.setEastBoundValue(minimapPadding);
        locatorProperties.setWestBoundValue(minimapPadding);
        this.setEditorProperties(locatorProperties);
    }

    public void draw(Region window, Region content, double scaleFactor, double zoomFactor) {
        double x = Math.round(-content.getLayoutX() * scaleFactor / zoomFactor);
        double y = Math.round(-content.getLayoutY() * scaleFactor / zoomFactor);
        double width = Math.round(window.getWidth() * scaleFactor / zoomFactor);
        double height = Math.round(window.getHeight() * scaleFactor / zoomFactor);
        this.setLayoutX(x + this.minimapPadding);
        this.setLayoutY(y + this.minimapPadding);
        this.getBorderRectangle().setWidth(width);
        this.getBorderRectangle().setHeight(height);
    }
}

