/*
 * Decompiled with CFR 0.152.
 */
package de.tesis.dynaware.grapheditor.utils;

import de.tesis.dynaware.grapheditor.utils.GraphEditorProperties;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Point2D;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;

public class DraggableBox
extends StackPane {
    private static final double DEFAULT_ALIGNMENT_THRESHOLD = 5.0;
    protected boolean dragActive;
    protected double lastLayoutX;
    protected double lastLayoutY;
    protected double lastMouseX;
    protected double lastMouseY;
    protected double lastParentWidth;
    protected double lastParentHeight;
    protected double absoluteMaxWidth;
    protected double absoluteMaxHeight;
    protected GraphEditorProperties editorProperties = new GraphEditorProperties();
    private List<Double> alignmentTargetsX;
    private List<Double> alignmentTargetsY;
    private double alignmentThreshold = 5.0;
    private final Rectangle border;
    private final Rectangle background;
    private final BooleanProperty dragEnabledXProperty = new SimpleBooleanProperty(true);
    private final BooleanProperty dragEnabledYProperty = new SimpleBooleanProperty(true);
    private Point2D snapToGridOffset = new Point2D(0.0, 0.0);
    private boolean cacheWhenStationary;

    public DraggableBox() {
        this.border = new Rectangle();
        this.background = new Rectangle();
        this.background.widthProperty().bind((ObservableValue)this.border.widthProperty().subtract((ObservableNumberValue)this.border.strokeWidthProperty().multiply(2)));
        this.background.heightProperty().bind((ObservableValue)this.border.heightProperty().subtract((ObservableNumberValue)this.border.strokeWidthProperty().multiply(2)));
        this.prefWidthProperty().bind((ObservableValue)this.border.widthProperty());
        this.maxWidthProperty().bind((ObservableValue)this.border.widthProperty());
        this.prefHeightProperty().bind((ObservableValue)this.border.heightProperty());
        this.maxHeightProperty().bind((ObservableValue)this.border.heightProperty());
        this.getChildren().addAll((Object[])new Node[]{this.border, this.background});
        this.setPickOnBounds(false);
        this.setCache(this.cacheWhenStationary);
        this.cacheHintProperty().set((Object)CacheHint.DEFAULT);
        this.setOnMousePressed(event -> {
            if (!event.getButton().equals((Object)MouseButton.PRIMARY)) {
                return;
            }
            if (this.cacheWhenStationary) {
                this.setCache(false);
            }
            this.storeClickValuesForDrag(event.getSceneX(), event.getSceneY());
            this.dragActive = true;
            event.consume();
        });
        this.setOnMouseDragged(event -> {
            if (!event.getButton().equals((Object)MouseButton.PRIMARY)) {
                return;
            }
            if (!this.dragActive) {
                this.storeClickValuesForDrag(event.getSceneX(), event.getSceneY());
            }
            this.handleDrag(event.getSceneX(), event.getSceneY());
            this.dragActive = true;
            event.consume();
        });
        this.setOnMouseReleased(event -> {
            if (!event.getButton().equals((Object)MouseButton.PRIMARY)) {
                return;
            }
            this.dragActive = false;
            if (this.cacheWhenStationary) {
                this.setCache(true);
            }
            event.consume();
        });
    }

    public Rectangle getBorderRectangle() {
        return this.border;
    }

    public Rectangle getBackgroundRectangle() {
        return this.background;
    }

    public void setEditorProperties(GraphEditorProperties editorProperties) {
        this.editorProperties = editorProperties;
    }

    public boolean isDragEnabledX() {
        return this.dragEnabledXProperty.get();
    }

    public void setDragEnabledX(boolean dragEnabledX) {
        this.dragEnabledXProperty.set(dragEnabledX);
    }

    public BooleanProperty dragEnabledXProperty() {
        return this.dragEnabledXProperty;
    }

    public boolean isDragEnabledY() {
        return this.dragEnabledYProperty.get();
    }

    public void setDragEnabledY(boolean dragEnabledY) {
        this.dragEnabledYProperty.set(dragEnabledY);
    }

    public BooleanProperty dragEnabledYProperty() {
        return this.dragEnabledYProperty;
    }

    public List<Double> getAlignmentTargetsX() {
        return this.alignmentTargetsX;
    }

    public void setAlignmentTargetsX(List<Double> alignmentTargetsX) {
        this.alignmentTargetsX = alignmentTargetsX;
    }

    public List<Double> getAlignmentTargetsY() {
        return this.alignmentTargetsY;
    }

    public void setAlignmentTargetsY(List<Double> alignmentTargetsY) {
        this.alignmentTargetsY = alignmentTargetsY;
    }

    public double getAlignmentThreshold() {
        return this.alignmentThreshold;
    }

    public void setAlignmentThreshold(double alignmentThreshold) {
        this.alignmentThreshold = alignmentThreshold;
    }

    public Point2D getSnapToGridOffset() {
        return this.snapToGridOffset;
    }

    public void setSnapToGridOffset(Point2D snapToGridOffset) {
        this.snapToGridOffset = snapToGridOffset;
    }

    public void setCacheWhenStationary(boolean cacheWhenStationary) {
        this.cacheWhenStationary = cacheWhenStationary;
        this.setCache(cacheWhenStationary);
    }

    protected void storeClickValuesForDrag(double x, double y) {
        this.lastLayoutX = this.getLayoutX();
        this.lastLayoutY = this.getLayoutY();
        this.lastMouseX = x;
        this.lastMouseY = y;
        Region container = this.getContainer((Node)this);
        this.lastParentWidth = container != null && container.getWidth() > 0.0 ? container.getWidth() : Double.MAX_VALUE;
        this.lastParentHeight = container != null && container.getHeight() > 0.0 ? container.getHeight() : Double.MAX_VALUE;
        this.absoluteMaxWidth = container != null && container.getMaxWidth() > 0.0 ? container.getMaxWidth() : Double.MAX_VALUE;
        this.absoluteMaxHeight = container != null && container.getMaxHeight() > 0.0 ? container.getMaxHeight() : Double.MAX_VALUE;
    }

    protected double roundToGridSpacing(double value) {
        double spacing = this.editorProperties.getGridSpacing();
        return spacing * (double)Math.round(value / spacing);
    }

    private void handleDrag(double x, double y) {
        if (this.dragEnabledXProperty.get()) {
            this.handleDragX(x);
        }
        if (this.dragEnabledYProperty.get()) {
            this.handleDragY(y);
        }
    }

    private void handleDragX(double x) {
        double maxParentWidth = this.editorProperties.isEastBoundActive() ? this.lastParentWidth : this.absoluteMaxWidth;
        double minLayoutX = this.editorProperties.getWestBoundValue();
        double maxLayoutX = maxParentWidth - this.getWidth() - this.editorProperties.getEastBoundValue();
        double scaleFactor = this.getLocalToSceneTransform().getMxx();
        double newLayoutX = this.lastLayoutX + (x - this.lastMouseX) / scaleFactor;
        if (this.editorProperties.isSnapToGridOn()) {
            newLayoutX = this.roundToGridSpacing(newLayoutX - this.snapToGridOffset.getX()) + this.snapToGridOffset.getX() - 1.0;
        } else {
            newLayoutX = Math.round(newLayoutX);
            if (this.alignmentTargetsX != null) {
                newLayoutX = this.align(newLayoutX, this.alignmentTargetsX);
            }
        }
        if (this.editorProperties.isWestBoundActive() && newLayoutX < minLayoutX) {
            newLayoutX = minLayoutX;
        } else if (newLayoutX > maxLayoutX) {
            newLayoutX = maxLayoutX;
        }
        this.setLayoutX(newLayoutX);
    }

    private void handleDragY(double y) {
        double maxParentHeight = this.editorProperties.isSouthBoundActive() ? this.lastParentHeight : this.absoluteMaxHeight;
        double minLayoutY = this.editorProperties.getNorthBoundValue();
        double maxLayoutY = maxParentHeight - this.getHeight() - this.editorProperties.getSouthBoundValue();
        double scaleFactor = this.getLocalToSceneTransform().getMxx();
        double newLayoutY = this.lastLayoutY + (y - this.lastMouseY) / scaleFactor;
        if (this.editorProperties.isSnapToGridOn()) {
            newLayoutY = this.roundToGridSpacing(newLayoutY - this.snapToGridOffset.getY()) + this.snapToGridOffset.getY() - 1.0;
        } else {
            newLayoutY = Math.round(newLayoutY);
            if (this.alignmentTargetsY != null) {
                newLayoutY = this.align(newLayoutY, this.alignmentTargetsY);
            }
        }
        if (this.editorProperties.isNorthBoundActive() && newLayoutY < minLayoutY) {
            newLayoutY = minLayoutY;
        } else if (newLayoutY > maxLayoutY) {
            newLayoutY = maxLayoutY;
        }
        this.setLayoutY(newLayoutY);
    }

    private Region getContainer(Node node) {
        Parent parent = node.getParent();
        if (parent == null) {
            return null;
        }
        if (parent instanceof Region) {
            return (Region)parent;
        }
        return this.getContainer((Node)parent);
    }

    private double align(double position, List<Double> alignmentValues) {
        for (Double alignmentValue : alignmentValues) {
            if (!(Math.abs(alignmentValue - position) <= this.alignmentThreshold)) continue;
            return alignmentValue;
        }
        return position;
    }
}

