/*
 * Decompiled with CFR 0.152.
 */
package de.tesis.dynaware.grapheditor;

import de.tesis.dynaware.grapheditor.GConnectorSkin;
import de.tesis.dynaware.grapheditor.GraphEditor;
import de.tesis.dynaware.grapheditor.model.GNode;
import de.tesis.dynaware.grapheditor.utils.ResizableBox;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.geometry.Point2D;

public abstract class GNodeSkin {
    private final GNode node;
    private final ResizableBox root = new ResizableBox(){

        protected void layoutChildren() {
            super.layoutChildren();
            GNodeSkin.this.layoutConnectors();
        }
    };
    private GraphEditor graphEditor;
    private final BooleanProperty selectedProperty = new SimpleBooleanProperty(false);

    public GNodeSkin(GNode node) {
        this.node = node;
    }

    public GNode getNode() {
        return this.node;
    }

    public ResizableBox getRoot() {
        return this.root;
    }

    public void setGraphEditor(GraphEditor graphEditor) {
        this.graphEditor = graphEditor;
    }

    public GraphEditor getGraphEditor() {
        return this.graphEditor;
    }

    public boolean isSelected() {
        return this.selectedProperty.get();
    }

    public void setSelected(boolean isSelected) {
        this.selectedProperty.set(isSelected);
    }

    public BooleanProperty selectedProperty() {
        return this.selectedProperty;
    }

    public void initialize() {
        this.getRoot().setLayoutX(this.getNode().getX());
        this.getRoot().setLayoutY(this.getNode().getY());
        this.getRoot().getBorderRectangle().setWidth(this.getNode().getWidth());
        this.getRoot().getBorderRectangle().setHeight(this.getNode().getHeight());
    }

    public abstract void setConnectorSkins(List<GConnectorSkin> var1);

    public abstract void layoutConnectors();

    public abstract Point2D getConnectorPosition(GConnectorSkin var1);
}

