/*
 * Decompiled with CFR 0.152.
 */
package de.tesis.dynaware.grapheditor;

import de.tesis.dynaware.grapheditor.GraphEditor;
import de.tesis.dynaware.grapheditor.model.GJoint;
import de.tesis.dynaware.grapheditor.utils.DraggableBox;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;

public abstract class GJointSkin {
    private final GJoint joint;
    private final DraggableBox root = new DraggableBox();
    private GraphEditor graphEditor;
    private final BooleanProperty selectedProperty = new SimpleBooleanProperty(false);

    public GJointSkin(GJoint joint) {
        this.joint = joint;
    }

    public GJoint getJoint() {
        return this.joint;
    }

    public DraggableBox getRoot() {
        return this.root;
    }

    public void setGraphEditor(GraphEditor graphEditor) {
        this.graphEditor = graphEditor;
    }

    public GraphEditor getGraphEditor() {
        return this.graphEditor;
    }

    public boolean isSelected() {
        return this.selectedProperty.get();
    }

    public void setSelected(boolean isSelected) {
        this.selectedProperty.set(isSelected);
    }

    public BooleanProperty selectedProperty() {
        return this.selectedProperty;
    }

    public void initialize() {
        this.getRoot().setLayoutX(this.getJoint().getX() - this.getWidth() / 2.0);
        this.getRoot().setLayoutY(this.getJoint().getY() - this.getHeight() / 2.0);
    }

    public abstract double getWidth();

    public abstract double getHeight();
}

