/*
 * Decompiled with CFR 0.152.
 */
package de.tesis.dynaware.grapheditor;

import de.tesis.dynaware.grapheditor.GJointSkin;
import de.tesis.dynaware.grapheditor.SkinLookup;
import de.tesis.dynaware.grapheditor.model.GConnection;
import de.tesis.dynaware.grapheditor.model.GConnector;
import de.tesis.dynaware.grapheditor.model.GJoint;
import de.tesis.dynaware.grapheditor.model.GModel;
import de.tesis.dynaware.grapheditor.model.GNode;
import de.tesis.dynaware.grapheditor.model.GraphPackage;
import de.tesis.dynaware.grapheditor.utils.DraggableBox;
import de.tesis.dynaware.grapheditor.utils.ResizableBox;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Commands {
    private static final Logger LOGGER = LoggerFactory.getLogger(Commands.class);
    private static final EReference NODES = GraphPackage.Literals.GMODEL__NODES;
    private static final EReference CONNECTIONS = GraphPackage.Literals.GMODEL__CONNECTIONS;
    private static final EAttribute NODE_X = GraphPackage.Literals.GNODE__X;
    private static final EAttribute NODE_Y = GraphPackage.Literals.GNODE__Y;
    private static final EAttribute NODE_WIDTH = GraphPackage.Literals.GNODE__WIDTH;
    private static final EAttribute NODE_HEIGHT = GraphPackage.Literals.GNODE__HEIGHT;
    private static final EReference CONNECTOR_CONNECTIONS = GraphPackage.Literals.GCONNECTOR__CONNECTIONS;
    private static final EAttribute JOINT_X = GraphPackage.Literals.GJOINT__X;
    private static final EAttribute JOINT_Y = GraphPackage.Literals.GJOINT__Y;

    private Commands() {
    }

    public static void addNode(GModel model, GNode node) {
        Command command;
        EditingDomain editingDomain = Commands.getEditingDomain(model);
        if (editingDomain != null && (command = AddCommand.create((EditingDomain)editingDomain, (Object)model, (Object)NODES, (Object)node)).canExecute()) {
            editingDomain.getCommandStack().execute(command);
        }
    }

    public static void removeNode(GModel model, GNode node) {
        EditingDomain editingDomain = Commands.getEditingDomain(model);
        if (editingDomain != null) {
            CompoundCommand command = new CompoundCommand();
            command.append(RemoveCommand.create((EditingDomain)editingDomain, (Object)model, (Object)NODES, (Object)node));
            ArrayList<GConnection> connectionsToDelete = new ArrayList<GConnection>();
            for (GConnector connector : node.getConnectors()) {
                for (GConnection connection : connector.getConnections()) {
                    if (connection == null || connectionsToDelete.contains(connection)) continue;
                    connectionsToDelete.add(connection);
                }
            }
            for (GConnection connection : connectionsToDelete) {
                command.append(RemoveCommand.create((EditingDomain)editingDomain, (Object)model, (Object)CONNECTIONS, (Object)connection));
                GConnector source = connection.getSource();
                GConnector target = connection.getTarget();
                if (!node.equals(source.getParent())) {
                    command.append(RemoveCommand.create((EditingDomain)editingDomain, (Object)source, (Object)CONNECTOR_CONNECTIONS, (Object)connection));
                }
                if (node.equals(target.getParent())) continue;
                command.append(RemoveCommand.create((EditingDomain)editingDomain, (Object)target, (Object)CONNECTOR_CONNECTIONS, (Object)connection));
            }
            if (command.canExecute()) {
                editingDomain.getCommandStack().execute((Command)command);
            }
        }
    }

    public static void clear(GModel model) {
        EditingDomain editingDomain = Commands.getEditingDomain(model);
        if (editingDomain != null) {
            CompoundCommand compoundCommand = new CompoundCommand();
            compoundCommand.append(RemoveCommand.create((EditingDomain)editingDomain, (Object)model, (Object)CONNECTIONS, (Collection)model.getConnections()));
            compoundCommand.append(RemoveCommand.create((EditingDomain)editingDomain, (Object)model, (Object)NODES, (Collection)model.getNodes()));
            if (compoundCommand.canExecute()) {
                editingDomain.getCommandStack().execute((Command)compoundCommand);
            }
        }
    }

    public static void updateLayoutValues(CompoundCommand command, GModel model, SkinLookup skinLookup) {
        EditingDomain editingDomain = Commands.getEditingDomain(model);
        if (editingDomain != null) {
            for (GNode node : model.getNodes()) {
                ResizableBox nodeRegion = skinLookup.lookupNode(node).getRoot();
                command.append(SetCommand.create((EditingDomain)editingDomain, (Object)node, (Object)NODE_X, (Object)nodeRegion.getLayoutX()));
                command.append(SetCommand.create((EditingDomain)editingDomain, (Object)node, (Object)NODE_Y, (Object)nodeRegion.getLayoutY()));
                command.append(SetCommand.create((EditingDomain)editingDomain, (Object)node, (Object)NODE_WIDTH, (Object)nodeRegion.getWidth()));
                command.append(SetCommand.create((EditingDomain)editingDomain, (Object)node, (Object)NODE_HEIGHT, (Object)nodeRegion.getHeight()));
            }
            for (GConnection connection : model.getConnections()) {
                for (GJoint joint : connection.getJoints()) {
                    GJointSkin jointSkin = skinLookup.lookupJoint(joint);
                    DraggableBox jointRegion = jointSkin.getRoot();
                    double x = jointRegion.getLayoutX() + jointSkin.getWidth() / 2.0;
                    double y = jointRegion.getLayoutY() + jointSkin.getHeight() / 2.0;
                    command.append(SetCommand.create((EditingDomain)editingDomain, (Object)joint, (Object)JOINT_X, (Object)x));
                    command.append(SetCommand.create((EditingDomain)editingDomain, (Object)joint, (Object)JOINT_Y, (Object)y));
                }
            }
        }
    }

    public static void undo(GModel model) {
        EditingDomain editingDomain = Commands.getEditingDomain(model);
        if (editingDomain != null && editingDomain.getCommandStack().canUndo()) {
            editingDomain.getCommandStack().undo();
        }
    }

    public static void redo(GModel model) {
        EditingDomain editingDomain = Commands.getEditingDomain(model);
        if (editingDomain != null && editingDomain.getCommandStack().canRedo()) {
            editingDomain.getCommandStack().redo();
        }
    }

    private static EditingDomain getEditingDomain(GModel model) {
        EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)model);
        if (editingDomain == null) {
            LOGGER.error("No editing domain found for this model. Maybe it hasn't been set inside a graph editor?");
        }
        return editingDomain;
    }
}

