/*
 * Decompiled with CFR 0.152.
 */
package de.telekom.test.bddwebapp.jbehave.steps;

import de.telekom.test.bddwebapp.jbehave.steps.Steps;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.steps.InjectableStepsFactory;
import org.jbehave.core.steps.InstanceStepsFactory;
import org.springframework.context.ApplicationContext;

public interface ScannedStepsFactory {
    default public InjectableStepsFactory scannedStepsFactory() {
        ArrayList steps = new ArrayList(this.getApplicationContext().getBeansWithAnnotation(Steps.class).values());
        return new InstanceStepsFactory(this.configuration(), steps);
    }

    default public InjectableStepsFactory testLevelStepsFactory(int testLevel) {
        ArrayList selectedSteps = new ArrayList();
        List<Object> stepsMatchingTestLevel = this.getApplicationContext().getBeansWithAnnotation(Steps.class).values().stream().filter(step -> step.getClass().getAnnotation(Steps.class).testLevel() <= testLevel).toList();
        stepsMatchingTestLevel.forEach(currentStep -> stepsMatchingTestLevel.stream().filter(step -> currentStep.getClass().isAssignableFrom(step.getClass()) || step.getClass().isAssignableFrom(currentStep.getClass())).max(Comparator.comparingInt(step -> step.getClass().getAnnotation(Steps.class).testLevel())).ifPresent(selectedSteps::add));
        return new InstanceStepsFactory(this.configuration(), selectedSteps);
    }

    default public int getTestLevel() {
        Integer testLevel = (Integer)this.getApplicationContext().getEnvironment().getProperty("testLevel", Integer.class);
        if (testLevel == null) {
            return 0;
        }
        return testLevel;
    }

    public ApplicationContext getApplicationContext();

    public Configuration configuration();
}

