/*
 * Decompiled with CFR 0.152.
 */
package de.telekom.test.bddwebapp.jbehave.stories.customizing;

import de.telekom.test.bddwebapp.frontend.lifecycle.WebDriverConfiguration;
import de.telekom.test.bddwebapp.jbehave.steps.RestartBrowserBeforeScenario;
import de.telekom.test.bddwebapp.jbehave.stories.config.AlternativeWebDriverConfiguration;
import de.telekom.test.bddwebapp.jbehave.stories.customizing.CustomizingStories;
import java.util.Arrays;
import java.util.Optional;
import org.jbehave.core.model.Meta;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CurrentStory {
    private final ThreadLocal<String> storyPath = new ThreadLocal();
    private final ThreadLocal<Meta> storyMetaData = new ThreadLocal();
    @Autowired
    private CustomizingStories customizingStories;

    public String getStoryPath() {
        return this.storyPath.get();
    }

    public void setStoryPath(String storyPath) {
        this.storyPath.set(storyPath);
    }

    public Meta getStoryMetaData() {
        return this.storyMetaData.get();
    }

    public void setStoryMetaData(Meta storyMetaData) {
        this.storyMetaData.set(storyMetaData);
    }

    public String getStoryName() {
        String storyPath = this.getStoryPath();
        if (storyPath == null) {
            return null;
        }
        return storyPath.substring(storyPath.lastIndexOf("/") + 1, storyPath.lastIndexOf("."));
    }

    public Class getStoryClass() {
        String storyName = this.getStoryName();
        if (storyName == null) {
            return null;
        }
        return this.customizingStories.getStoryClass(storyName);
    }

    public boolean isRestartBrowserBeforeScenario() {
        return this.isRestartBrowserBeforeScenarioForAllStories() || this.isRestartBrowserBeforeScenarioBaseType() || this.isRestartBrowserBeforeScenarioForCurrentStory();
    }

    private boolean isRestartBrowserBeforeScenarioForAllStories() {
        return this.customizingStories.isRestartBrowserBeforeScenarioForAllStories();
    }

    private boolean isRestartBrowserBeforeScenarioBaseType() {
        Class clazz = this.getStoryClass();
        return clazz != null && this.customizingStories.getRestartBrowserBeforeScenarioBaseType() != null && this.customizingStories.getRestartBrowserBeforeScenarioBaseType().isAssignableFrom(clazz);
    }

    private boolean isRestartBrowserBeforeScenarioForCurrentStory() {
        Class clazz = this.getStoryClass();
        return clazz != null && Arrays.stream(clazz.getAnnotations()).anyMatch(a -> a.annotationType().equals(RestartBrowserBeforeScenario.class));
    }

    public Optional<Class<? extends WebDriverConfiguration>> getAlternativeWebDriverConfiguration() {
        AlternativeWebDriverConfiguration alternativeWebDriverConfiguration;
        Class clazz = this.getStoryClass();
        if (clazz != null && (alternativeWebDriverConfiguration = clazz.getAnnotation(AlternativeWebDriverConfiguration.class)) != null) {
            return Optional.of(alternativeWebDriverConfiguration.value());
        }
        return Optional.empty();
    }
}

