/*
 * Decompiled with CFR 0.152.
 */
package de.telekom.test.bddwebapp.jbehave.stories;

import com.github.valfirst.jbehave.junit.monitoring.JUnitReportingRunner;
import de.telekom.test.bddwebapp.jbehave.steps.ScannedStepsFactory;
import de.telekom.test.bddwebapp.jbehave.stories.config.FaultTolerantStoryPathResolver;
import de.telekom.test.bddwebapp.jbehave.stories.config.ScreenshotStoryReporterBuilder;
import de.telekom.test.bddwebapp.jbehave.stories.customizing.CurrentStoryEmbedderMonitor;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.configuration.MostUsefulConfiguration;
import org.jbehave.core.embedder.Embedder;
import org.jbehave.core.embedder.EmbedderMonitor;
import org.jbehave.core.embedder.MetaFilter;
import org.jbehave.core.io.StoryNameResolver;
import org.jbehave.core.io.UnderscoredToCapitalized;
import org.jbehave.core.junit.JUnitStory;
import org.jbehave.core.model.Meta;
import org.jbehave.core.reporters.FreemarkerViewGenerator;
import org.jbehave.core.reporters.ViewGenerator;
import org.jbehave.core.steps.InjectableStepsFactory;
import org.junit.runner.RunWith;
import org.springframework.context.ApplicationContext;

@RunWith(value=JUnitReportingRunner.class)
public abstract class AbstractStory
extends JUnitStory
implements ScannedStepsFactory,
ScreenshotStoryReporterBuilder,
FaultTolerantStoryPathResolver {
    @Override
    public Configuration configuration() {
        MostUsefulConfiguration configuration = new MostUsefulConfiguration();
        configuration.useStoryReporterBuilder(this.screenshotStoryReporterBuilder());
        configuration.useStoryPathResolver(this.removeStoryFromClassNameStoryPathResolver());
        configuration.useViewGenerator((ViewGenerator)new FreemarkerViewGenerator((StoryNameResolver)new UnderscoredToCapitalized(), FreemarkerViewGenerator.class, StandardCharsets.UTF_8));
        return configuration;
    }

    public InjectableStepsFactory stepsFactory() {
        return this.scannedStepsFactory();
    }

    public Embedder configuredEmbedder() {
        Embedder embedder = super.configuredEmbedder();
        embedder.useEmbedderMonitor((EmbedderMonitor)new CurrentStoryEmbedderMonitor(this.getApplicationContext()));
        if (this.isExecutedByJUnitRunner()) {
            embedder.embedderControls().doGenerateViewAfterStories(false);
        }
        this.metaFilters().ifPresent(metaFilters -> {
            embedder.useMetaFilters(Arrays.asList(metaFilters.split(";")));
            this.supportForSingleScenarioExecution(embedder);
        });
        return embedder;
    }

    public boolean isExecutedByJUnitRunner() {
        String testClass = System.getProperty("test");
        return StringUtils.isBlank((CharSequence)testClass);
    }

    public Optional<String> metaFilters() {
        String metaFilters = System.getProperty("metaFilters");
        return Optional.ofNullable(metaFilters);
    }

    public void supportForSingleScenarioExecution(Embedder embedder) {
        embedder.metaMatchers().put("+scenario_title", new MetaFilter.MetaMatcher(){
            private String scenarioTitle;

            public void parse(String s) {
                this.scenarioTitle = s.substring(16);
                this.scenarioTitle = this.scenarioTitle.replace("*", ".*");
            }

            public boolean match(Meta meta) {
                if (!meta.hasProperty("title")) {
                    return true;
                }
                return meta.getProperty("title").trim().matches(this.scenarioTitle);
            }
        });
    }

    @Override
    public abstract ApplicationContext getApplicationContext();
}

