/*
 * Decompiled with CFR 0.152.
 */
package de.telekom.test.bddwebapp.cucumber.features;

import de.telekom.test.bddwebapp.cucumber.features.CustomizingFeatures;
import io.cucumber.java.Scenario;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CurrentFeature {
    private static final Logger log = LoggerFactory.getLogger(CurrentFeature.class);
    private String currentFeature;
    private Integer testCaseCountCurrentFeature = 0;
    @Autowired
    private CustomizingFeatures customizingFeatures;

    public boolean isRestartBrowserBeforeScenario() {
        return this.isRestartBrowserBeforeScenarioForAllStories() || this.isRestartBrowserBeforeScenarioForCurrentStory();
    }

    private boolean isRestartBrowserBeforeScenarioForCurrentStory() {
        return this.customizingFeatures.getRestartBrowserBeforeScenarioThisFeatures().stream().anyMatch(s -> s.equals(this.currentFeature));
    }

    private boolean isRestartBrowserBeforeScenarioForAllStories() {
        return this.customizingFeatures.isRestartBrowserBeforeScenarioForAllStories();
    }

    public boolean isBeforeFeature() {
        return this.testCaseCountCurrentFeature < 1;
    }

    public void beforeScenarioHook(Scenario scenario) {
        String featureNameFromScenario = CurrentFeature.getFeatureNameFromScenario(scenario);
        this.increaseTestCaseCount(featureNameFromScenario);
        this.handleCustomFeatureAnnotations(scenario);
    }

    public void increaseTestCaseCount(String feature) {
        if (feature.equals(this.currentFeature)) {
            Integer n = this.testCaseCountCurrentFeature;
            this.testCaseCountCurrentFeature = this.testCaseCountCurrentFeature + 1;
        } else {
            log.info("Execution for new feature {} is started", (Object)feature);
            this.currentFeature = feature;
            this.testCaseCountCurrentFeature = 0;
        }
    }

    public void handleCustomFeatureAnnotations(Scenario scenario) {
        if (scenario.getSourceTagNames() != null && scenario.getSourceTagNames().stream().anyMatch(s -> s.equals("@restartBrowserBeforeScenario"))) {
            this.customizingFeatures.getRestartBrowserBeforeScenarioThisFeatures().add(this.currentFeature);
        }
    }

    public static String getFeatureNameFromScenario(Scenario scenario) {
        String uri = scenario.getUri().toString();
        String feature = uri.replaceFirst(".+/", "");
        feature = feature.replaceFirst(":.*", "");
        return feature;
    }

    public String getCurrentFeature() {
        return this.currentFeature;
    }

    public Integer getTestCaseCountCurrentFeature() {
        return this.testCaseCountCurrentFeature;
    }
}

