/*
 * Decompiled with CFR 0.152.
 */
package de.telekom.test.bddwebapp.cucumber.steps;

import ch.qos.logback.classic.Level;
import de.telekom.test.bddwebapp.api.steps.ApiSteps;
import de.telekom.test.bddwebapp.cucumber.features.CurrentFeature;
import de.telekom.test.bddwebapp.cucumber.features.CustomizingFeatures;
import de.telekom.test.bddwebapp.interaction.InteractionParameterConverter;
import de.telekom.test.bddwebapp.interaction.ScenarioInteraction;
import de.telekom.test.bddwebapp.interaction.StoryInteraction;
import io.cucumber.java.Scenario;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public abstract class AbstractCucumberApiSpringConfigurationSteps
extends ApiSteps {
    private static final Logger log = LoggerFactory.getLogger(AbstractCucumberApiSpringConfigurationSteps.class);
    @Autowired
    protected ApplicationContext applicationContext;
    @Autowired
    protected ScenarioInteraction scenarioInteraction;
    @Autowired
    protected StoryInteraction storyInteraction;
    @Autowired
    protected InteractionParameterConverter interactionParameterConverter;
    @Autowired
    protected CustomizingFeatures customizingFeatures;
    @Autowired
    protected CurrentFeature currentFeature;
    protected boolean beforeAll = true;

    public void setupBddWebApp(Scenario scenario) {
        if (this.beforeAll) {
            this.setLogLevel();
        }
        this.startScenarioInteraction(scenario);
        this.currentFeature.beforeScenarioHook(scenario);
        this.startStoryInteraction(scenario);
    }

    public void setLogLevel() {
        ch.qos.logback.classic.Logger rootLogger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"ROOT");
        rootLogger.setLevel(Level.INFO);
    }

    public void startScenarioInteraction(Scenario scenario) {
        log.info("Reset scenario interaction");
        this.scenarioInteraction.startInteraction();
    }

    public void startStoryInteraction(Scenario scenario) {
        if (this.currentFeature.isBeforeFeature()) {
            log.info("Reset story interaction");
            this.storyInteraction.startInteraction();
        }
    }

    public String resolveInteractionKey(String interactionKey) {
        return (String)this.interactionParameterConverter.getValueFromKeyOrValueOrConcatenated(interactionKey);
    }
}

