/*
 * Decompiled with CFR 0.152.
 */
package de.telekom.test.bddwebapp.api.steps;

import io.restassured.RestAssured;
import io.restassured.config.DecoderConfig;
import io.restassured.config.EncoderConfig;
import io.restassured.config.ObjectMapperConfig;
import io.restassured.config.RestAssuredConfig;
import io.restassured.http.ContentType;
import io.restassured.mapper.ObjectMapperType;
import io.restassured.response.Response;
import io.restassured.specification.RequestSpecification;
import io.restassured.specification.ResponseSpecification;
import java.net.URI;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public interface RestAssuredSteps {
    public static final String REQUEST_INTERACTION_KEY = "request";
    public static final String RESPONSE_INTERACTION_KEY = "response";

    public RequestSpecification recallRequest();

    public void rememberRequest(RequestSpecification var1);

    public Response recallResponse();

    default public Map<String, Object> recallResponseAsMap() {
        try {
            return (Map)this.recallResponse().getBody().as(Map.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Error converting rest recallResponse to map. Response: [" + this.recallResponse().getBody().asString() + "]", e);
        }
    }

    default public RequestSpecification createRequest() {
        RequestSpecification request = ((ResponseSpecification)((RequestSpecification)RestAssured.given().log().all()).expect().log().all()).request();
        this.rememberRequest(request);
        return request;
    }

    default public RequestSpecification createRequestWithBaseUriAndProxy(String host, String apiPath, String proxyHost, String proxyPort) {
        this.createRequest();
        this.baseUri(host, apiPath);
        this.proxy(proxyHost, proxyPort);
        return this.recallRequest();
    }

    default public RequestSpecification createRequestWithJsonConfig(String host, String apiPath, String proxyHost, String proxyPort) {
        this.createRequestWithBaseUriAndProxy(host, apiPath, proxyHost, proxyPort);
        this.jsonConfig();
        return this.recallRequest();
    }

    default public RequestSpecification baseUri(String host, String apiPath) {
        RequestSpecification requestSpecification = this.recallRequest();
        try {
            URI baseURI = new URI(host);
            requestSpecification.baseUri(baseURI.toString()).basePath(apiPath);
            int port = baseURI.getPort() > 0 ? baseURI.getPort() : this.determineStandardPortForScheme(baseURI.getScheme());
            requestSpecification.port(port);
            this.rememberRequest(requestSpecification);
        }
        catch (Exception ex) {
            throw new RuntimeException("Error setting baseUri for recallRequest", ex);
        }
        return requestSpecification;
    }

    default public int determineStandardPortForScheme(String scheme) {
        if (scheme.equalsIgnoreCase("https")) {
            return 443;
        }
        return 80;
    }

    default public RequestSpecification proxy(String proxyHost, String proxyPort) {
        if (StringUtils.isBlank((CharSequence)proxyHost) || StringUtils.isBlank((CharSequence)proxyPort)) {
            return this.recallRequest();
        }
        return this.proxy(proxyHost, new Integer(proxyPort));
    }

    default public RequestSpecification proxy(String proxyHost, Integer proxyPort) {
        if (StringUtils.isBlank((CharSequence)proxyHost) || proxyPort == null || proxyPort == 0) {
            return this.recallRequest();
        }
        return this.recallRequest().proxy(proxyHost, proxyPort.intValue());
    }

    default public RequestSpecification jsonConfig() {
        RestAssuredConfig restAssuredConfig = new RestAssuredConfig().decoderConfig(new DecoderConfig("UTF-8")).encoderConfig(new EncoderConfig("UTF-8", "UTF-8")).objectMapperConfig(new ObjectMapperConfig(ObjectMapperType.JACKSON_2));
        RequestSpecification requestSpecification = this.recallRequest();
        requestSpecification.config(restAssuredConfig);
        requestSpecification.header("Accept", (Object)ContentType.JSON.toString(), new Object[0]);
        requestSpecification.header("Content-Type", (Object)ContentType.JSON.toString(), new Object[0]);
        return requestSpecification;
    }
}

