/*
 * Decompiled with CFR 0.152.
 */
package de.telekom.test.bddwebapp.frontend.util;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class UrlAppender {
    private UrlAppender() {
    }

    public static String appendUrl(String url, String ... appenders) {
        StringBuilder urlBuilder = new StringBuilder(url);
        for (String appender : appenders) {
            boolean alreadyAppended = false;
            if (urlBuilder.toString().endsWith("/") && appender.startsWith("/")) {
                urlBuilder.append(StringUtils.substring((String)appender, (int)1));
                alreadyAppended = true;
            }
            if (alreadyAppended) continue;
            if (urlBuilder.toString().endsWith("/") || appender.startsWith("/")) {
                urlBuilder.append(appender);
                continue;
            }
            urlBuilder.append("/").append(appender);
        }
        url = urlBuilder.toString();
        return url;
    }

    public static String appendQueryParams(String url, Map<String, String> queryParams) {
        if (queryParams != null && queryParams.size() > 0) {
            StringBuilder query = new StringBuilder();
            boolean isFirstparameter = true;
            for (String key : queryParams.keySet()) {
                if (isFirstparameter) {
                    isFirstparameter = false;
                } else {
                    query.append("&");
                }
                String value = queryParams.get(key);
                if (StringUtils.isEmpty((CharSequence)value)) {
                    query.append(key);
                    continue;
                }
                query.append(key).append("=").append(value);
            }
            url = (String)url + "?" + query;
        }
        return url;
    }
}

