/*
 * Decompiled with CFR 0.152.
 */
package de.telekom.test.bddwebapp.frontend.steps;

import de.telekom.test.bddwebapp.api.steps.ApiSteps;
import de.telekom.test.bddwebapp.frontend.element.decorator.WebElementDecorator;
import de.telekom.test.bddwebapp.frontend.lifecycle.WebDriverWrapper;
import de.telekom.test.bddwebapp.frontend.page.Page;
import de.telekom.test.bddwebapp.frontend.util.UrlAppender;
import de.telekom.test.bddwebapp.interaction.InteractionParameterConverter;
import de.telekom.test.bddwebapp.interaction.StoryInteraction;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.PageFactory;
import org.openqa.selenium.support.pagefactory.FieldDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class SeleniumSteps
extends ApiSteps {
    private static final Logger log = LoggerFactory.getLogger(SeleniumSteps.class);
    public static final String CURRENT_PAGE = "CURRENT_PAGE";
    public static final String QUERY_PARAMS = "QUERY_PARAMS";
    @Autowired
    protected WebDriverWrapper webDriverWrapper;
    @Autowired
    protected StoryInteraction storyInteraction;
    @Autowired
    protected InteractionParameterConverter interactionParameterConverter;

    protected <T extends Page> T createExpectedPage(Class<T> expectedPage) {
        Page page;
        WebDriver driver = this.webDriverWrapper.getDriver();
        try {
            Constructor<T> constructor = expectedPage.getConstructor(WebDriver.class);
            page = (Page)constructor.newInstance(driver);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        PageFactory.initElements((FieldDecorator)new WebElementDecorator(driver), (Object)page);
        page.checkPage();
        this.storyInteraction.remember(CURRENT_PAGE, (Object)page);
        log.info("Created page object for class " + expectedPage);
        return (T)page;
    }

    protected <T extends Page> T getCurrentPage() {
        return (T)((Page)this.storyInteraction.recall(CURRENT_PAGE));
    }

    protected String getUrlWithHost(String hostIncludingPort, String path) {
        return UrlAppender.appendUrl(hostIncludingPort, path);
    }

    protected String getUrlWithHost(String hostIncludingPort, String contextPath, String path) {
        return UrlAppender.appendUrl(hostIncludingPort, contextPath, path);
    }

    protected String getUrlWithHost(String hostIncludingPort, String contextPath, String path, Map<String, String> queryParams) {
        String url = UrlAppender.appendUrl(hostIncludingPort, contextPath, path);
        return UrlAppender.appendQueryParams(url, queryParams);
    }

    protected void open(String url) {
        WebDriver driver = this.webDriverWrapper.getDriver();
        driver.get(url);
    }

    protected Map<String, String> mapQueryParam() {
        return this.getMapFromStoryInteraction();
    }

    protected <T> Map<String, T> getMapFromStoryInteraction() {
        return this.scenarioInteraction.recallMapOrCreateNew(QUERY_PARAMS);
    }
}

