/*
 * Decompiled with CFR 0.152.
 */
package de.telekom.test.bddwebapp.frontend.lifecycle;

import de.telekom.test.bddwebapp.frontend.lifecycle.UsefulWebDriverConfiguration;
import de.telekom.test.bddwebapp.frontend.lifecycle.WebDriverConfiguration;
import java.io.File;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.remote.UnreachableBrowserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WebDriverWrapper {
    private static final Logger log = LoggerFactory.getLogger(WebDriverWrapper.class);
    public static Class<? extends WebDriverConfiguration> DEFAULT_WEB_DRIVER_CONFIGURATION = UsefulWebDriverConfiguration.class;
    @Autowired
    private List<WebDriverConfiguration> webDriverConfigurations;
    private Class<? extends WebDriverConfiguration> alternativeWebDriverConfiguration;
    private WebDriver driver;

    public WebDriver getDriver() {
        if (this.isClosed()) {
            this.loadWebdriver();
        }
        return this.driver;
    }

    public WebDriverConfiguration getCurrentWebDriverConfiguration() {
        return Optional.ofNullable(this.alternativeWebDriverConfiguration).map(this::getAlternativeWebDriverConfiguration).orElse(this.getDefaultWebDriverConfiguration());
    }

    public void resetAlternativeWebDriverConfiguration() {
        this.alternativeWebDriverConfiguration = null;
    }

    public WebDriverConfiguration getAlternativeWebDriverConfiguration(Class<? extends WebDriverConfiguration> alternativeWebDriverConfigurationClass) {
        return this.webDriverConfigurations.stream().filter(webDriverConfiguration -> webDriverConfiguration.getClass().equals(alternativeWebDriverConfigurationClass)).findFirst().get();
    }

    public WebDriverConfiguration getDefaultWebDriverConfiguration() {
        return this.webDriverConfigurations.stream().filter(webDriverConfiguration -> webDriverConfiguration.getClass().equals(DEFAULT_WEB_DRIVER_CONFIGURATION)).findFirst().get();
    }

    public void loadWebdriver() {
        WebDriverConfiguration webDriverConfiguration = this.getCurrentWebDriverConfiguration();
        this.driver = webDriverConfiguration.loadWebdriver();
        webDriverConfiguration.afterLoad(this.driver);
    }

    public void quit() {
        if (this.driver != null) {
            try {
                this.driver.quit();
            }
            catch (UnreachableBrowserException unreachableBrowserException) {
                log.error(unreachableBrowserException.getMessage());
            }
        }
        this.driver = null;
    }

    public boolean isClosed() {
        return this.driver == null;
    }

    public String createScreenshot(String path) {
        try {
            log.info("Create screenshot to '{}'", (Object)path);
            if (this.driver == null) {
                log.error("Can not create screenshot because webdriver is null!");
                return null;
            }
            if (this.driver instanceof HtmlUnitDriver) {
                log.error("Can not create screenshots for htmlunit!");
                return null;
            }
            File screenshot = (File)((TakesScreenshot)this.driver).getScreenshotAs(OutputType.FILE);
            File destFile = new File(path);
            FileUtils.copyFile((File)screenshot, (File)destFile);
            return destFile.getAbsolutePath();
        }
        catch (Exception e) {
            log.error("Exception at capture screenshot", (Throwable)e);
            return null;
        }
    }

    public Class<? extends WebDriverConfiguration> getAlternativeWebDriverConfiguration() {
        return this.alternativeWebDriverConfiguration;
    }

    public void setAlternativeWebDriverConfiguration(Class<? extends WebDriverConfiguration> alternativeWebDriverConfiguration) {
        this.alternativeWebDriverConfiguration = alternativeWebDriverConfiguration;
    }

    public void setDriver(WebDriver driver) {
        this.driver = driver;
    }
}

