/*
 * Decompiled with CFR 0.152.
 */
package de.telekom.test.bddwebapp.frontend.element.decorator;

import de.telekom.test.bddwebapp.frontend.element.WebElementEnhanced;
import de.telekom.test.bddwebapp.frontend.element.decorator.WebElementHandler;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import lombok.NonNull;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.pagefactory.DefaultElementLocatorFactory;
import org.openqa.selenium.support.pagefactory.DefaultFieldDecorator;
import org.openqa.selenium.support.pagefactory.ElementLocator;
import org.openqa.selenium.support.pagefactory.ElementLocatorFactory;
import org.openqa.selenium.support.pagefactory.FieldDecorator;

public class WebElementDecorator
implements FieldDecorator {
    @NonNull
    private final WebDriver webDriver;

    public Object decorate(ClassLoader loader, Field field) {
        DefaultElementLocatorFactory defaultElementLocatorFactory = new DefaultElementLocatorFactory((SearchContext)this.webDriver);
        if (this.isWebElementEnhanced(field)) {
            return this.getEnhancedObject(field, defaultElementLocatorFactory);
        }
        if (this.isListWithWebElementEnhanced(field)) {
            return this.getEnhancedObject(field, defaultElementLocatorFactory);
        }
        return new DefaultFieldDecorator((ElementLocatorFactory)defaultElementLocatorFactory).decorate(loader, field);
    }

    protected boolean isWebElementEnhanced(Field field) {
        return WebElementEnhanced.class.isAssignableFrom(field.getType()) && field.isAnnotationPresent(FindBy.class);
    }

    protected boolean isListWithWebElementEnhanced(Field field) {
        return List.class.isAssignableFrom(field.getType()) && WebElementEnhanced.class.isAssignableFrom((Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0]) && field.isAnnotationPresent(FindBy.class);
    }

    protected Object getEnhancedObject(Field field, DefaultElementLocatorFactory defaultElementLocatorFactory) {
        Enhancer e = new Enhancer();
        e.setSuperclass(field.getType());
        ElementLocator locator = defaultElementLocatorFactory.createLocator(field);
        e.setCallback((Callback)new WebElementHandler(this.webDriver, locator));
        return e.create();
    }

    public WebElementDecorator(@NonNull WebDriver webDriver) {
        if (webDriver == null) {
            throw new NullPointerException("webDriver is marked non-null but is null");
        }
        this.webDriver = webDriver;
    }
}

