/*
 * Decompiled with CFR 0.152.
 */
package de.telekom.test.bddwebapp.stories.config;

import de.telekom.test.bddwebapp.stories.AbstractStory;
import de.telekom.test.bddwebapp.stories.config.TestLevel;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.io.StoryPathResolver;
import org.junit.Ignore;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;

public interface ScannedStoryPaths {
    default public List<String> scannedStoryPaths() {
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false);
        provider.addIncludeFilter((TypeFilter)new AssignableTypeFilter(AbstractStory.class));
        provider.addExcludeFilter((TypeFilter)new AnnotationTypeFilter(Ignore.class));
        Set components = provider.findCandidateComponents(this.storiesBasePath());
        StoryPathResolver storyPathResolver = this.configuration().storyPathResolver();
        return components.stream().map(beanDefinition -> ClassUtils.resolveClassName((String)Objects.requireNonNull(beanDefinition.getBeanClassName()), (ClassLoader)ClassUtils.getDefaultClassLoader())).map(aClass -> storyPathResolver.resolve(aClass)).collect(Collectors.toList());
    }

    default public List<String> testLevelStoryPaths(int testLevel) {
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false);
        provider.addIncludeFilter((TypeFilter)new AssignableTypeFilter(AbstractStory.class));
        provider.addExcludeFilter((TypeFilter)new AnnotationTypeFilter(Ignore.class));
        Set components = provider.findCandidateComponents(this.storiesBasePath());
        StoryPathResolver storyPathResolver = this.configuration().storyPathResolver();
        return components.stream().map(beanDefinition -> ClassUtils.resolveClassName((String)Objects.requireNonNull(beanDefinition.getBeanClassName()), (ClassLoader)ClassUtils.getDefaultClassLoader())).filter(aClass -> {
            TestLevel atl = aClass.getAnnotation(TestLevel.class);
            return atl == null && testLevel == 0 || atl != null && Arrays.stream(atl.testLevels()).anyMatch(tl -> tl == testLevel);
        }).map(aClass -> storyPathResolver.resolve(aClass)).collect(Collectors.toList());
    }

    default public String storiesBasePath() {
        return "";
    }

    public Configuration configuration();
}

