/*
 * Decompiled with CFR 0.152.
 */
package de.telekom.test.bddwebapp.interaction;

import de.telekom.test.bddwebapp.interaction.FlatInteraction;
import de.telekom.test.bddwebapp.interaction.ScenarioInteraction;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.ProxyFactoryBean;
import org.springframework.aop.target.ThreadLocalTargetSource;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Configuration
@Component
@Scope(scopeName="prototype")
public class StoryInteraction
extends FlatInteraction {
    private ScenarioInteraction scenarioInteraction;

    public void rememberFromScenarioInteraction(String key) {
        super.remember(key, this.scenarioInteraction.recallNotNull(key));
    }

    public void rememberObjectFromScenarioInteraction(String entityKey, String objectKey) {
        super.rememberObject(entityKey, objectKey, this.scenarioInteraction.recallObjectNotNull(entityKey, objectKey));
    }

    @Bean(destroyMethod="destroy")
    public ThreadLocalTargetSource threadLocalStoryInteraction() {
        ThreadLocalTargetSource result = new ThreadLocalTargetSource();
        result.setTargetBeanName("storyInteraction");
        return result;
    }

    @Primary
    @Bean(name={"proxiedThreadLocalTargetSourceStoryInteraction"})
    public ProxyFactoryBean proxiedThreadLocalTargetSourceStoryInteraction(@Qualifier(value="threadLocalStoryInteraction") ThreadLocalTargetSource threadLocalStoryInteraction) {
        ProxyFactoryBean result = new ProxyFactoryBean();
        result.setProxyTargetClass(true);
        result.setTargetSource((TargetSource)threadLocalStoryInteraction);
        return result;
    }

    public void setScenarioInteraction(ScenarioInteraction scenarioInteraction) {
        this.scenarioInteraction = scenarioInteraction;
    }
}

