/*
 * Decompiled with CFR 0.152.
 */
package de.telekom.test.bddwebapp.frontend.screenshot;

import de.telekom.test.bddwebapp.frontend.screenshot.ScreenshotCreator;
import de.telekom.test.bddwebapp.stories.customizing.CurrentStory;
import java.io.PrintStream;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jbehave.core.failures.PendingStepFound;
import org.jbehave.core.model.Story;
import org.jbehave.core.reporters.HtmlOutput;
import org.jbehave.core.reporters.StoryReporterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScreenshotHtmlOutput
extends HtmlOutput {
    private static final Logger log = LoggerFactory.getLogger(ScreenshotHtmlOutput.class);
    protected final boolean screenshotsOnSuccess;
    protected final ScreenshotCreator screenshotCreator;
    protected final CurrentStory currentStory;
    protected String currentStoryFolder;

    public ScreenshotHtmlOutput(PrintStream output, StoryReporterBuilder reporterBuilder, boolean screenshotsOnSuccess, ScreenshotCreator screenshotCreator, CurrentStory currentStory) {
        super(output, reporterBuilder.keywords());
        this.screenshotsOnSuccess = screenshotsOnSuccess;
        this.screenshotCreator = screenshotCreator;
        this.currentStory = currentStory;
        this.successScreenshotPattern();
        this.failedScreenshotPattern();
    }

    protected void successScreenshotPattern() {
        if (this.screenshotsOnSuccess) {
            super.overwritePattern("successfulWithScreenshot", "<div class=\"step successful\"><a target=\"_blank\" href=\"{0}\">{1}</a></div>\n");
        }
    }

    protected void failedScreenshotPattern() {
        super.overwritePattern("failedWithScreenshot", "<div class=\"step failed\"><a style=\"color: darkmagenta; font-weight: none; text-decoration: underline;\" target=\"_blank\" href=\"{3}\">{0}</a> <span class=\"keyword failed\">({1})</span><br/><span class=\"message failed\">{2}</span></div>");
    }

    public void beforeStory(Story story, boolean givenStory) {
        super.beforeStory(story, givenStory);
        this.currentStoryFolder = story.getName() + "_" + new Date().getTime();
        this.currentStory.setStoryMetaData(story.getMeta());
    }

    public void successful(String step) {
        log.info("Successful execution of step: \"" + step + "\"");
        if (!(this.screenshotsOnSuccess && step.contains("Then") && this.successfulScreenshot(step))) {
            super.successful(step);
        }
    }

    protected boolean successfulScreenshot(String step) {
        String screenshotPath = this.screenshotCreator.createScreenshot(this.currentStoryFolder, step, "successful");
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{screenshotPath})) {
            this.print(this.format("successfulWithScreenshot", "{0} {1}\n", new Object[]{screenshotPath, step}));
            return true;
        }
        return false;
    }

    public void failed(String step, Throwable storyFailure) {
        log.info("Failed execution of step: \"" + step + "\"");
        if (storyFailure instanceof PendingStepFound || !this.failedScreenshot(step, storyFailure)) {
            super.failed(step, storyFailure);
        }
    }

    protected boolean failedScreenshot(String step, Throwable storyFailure) {
        String screenshotPath = this.screenshotCreator.createScreenshot(this.currentStoryFolder, step, "failed");
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{screenshotPath})) {
            String stackTrace = ExceptionUtils.getStackTrace((Throwable)storyFailure.getCause());
            this.print(this.format("failedWithScreenshot", "{3} {0} ({1})\n({2})\n", new Object[]{step, "FAILED", stackTrace, screenshotPath}));
            return true;
        }
        return false;
    }
}

