/*
 * Decompiled with CFR 0.152.
 */
package de.telekom.test.bddwebapp.frontend.page;

import de.telekom.test.bddwebapp.frontend.page.UrlMatchesExpectation;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.ui.WebDriverWait;

public abstract class Page {
    protected final WebDriver driver;

    public Page(WebDriver driver) {
        this.driver = driver;
    }

    public void checkPage() {
        this.checkUrl();
        this.checkPageState();
        this.checkPageDesignator();
    }

    public void checkUrl() {
        WebDriverWait wait = new WebDriverWait(this.driver, 15L);
        wait.until((Function)((Object)new UrlMatchesExpectation(this.getURL(), this.getClass().getName())));
    }

    public void checkPageState() {
        if (this.driver instanceof JavascriptExecutor) {
            WebDriverWait wait = new WebDriverWait(this.driver, 15L);
            wait.until(driver -> ((JavascriptExecutor)driver).executeScript("return document.readyState", new Object[0]).equals("complete"));
        }
    }

    public void checkPageDesignator() {
    }

    public void reload() {
        this.driver.navigate().refresh();
    }

    public void waitFor(long milliseconds) {
        try {
            TimeUnit.MILLISECONDS.sleep(milliseconds);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public abstract String getURL();
}

