/*
 * Decompiled with CFR 0.152.
 */
package de.telekom.test.bddwebapp.frontend.lifecycle;

import de.telekom.test.bddwebapp.frontend.lifecycle.UsefulWebDriverConfiguration;
import de.telekom.test.bddwebapp.frontend.lifecycle.WebDriverConfiguration;
import java.io.File;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.remote.UnreachableBrowserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WebDriverWrapper {
    private static final Logger log = LoggerFactory.getLogger(WebDriverWrapper.class);
    public static Class<? extends WebDriverConfiguration> DEFAULT_WEB_DRIVER_CONFIGURATION = UsefulWebDriverConfiguration.class;
    private final ThreadLocal<WebDriver> webDriver = new ThreadLocal();
    private final ThreadLocal<Class<? extends WebDriverConfiguration>> alternativeWebDriverConfiguration = new ThreadLocal();
    @Autowired
    private List<WebDriverConfiguration> webDriverConfigurations;

    public WebDriver getDriver() {
        WebDriver webDriver = this.webDriver.get();
        if (webDriver == null) {
            this.loadWebdriver();
        }
        return this.webDriver.get();
    }

    public void setDriver(WebDriver webDriver) {
        this.webDriver.set(webDriver);
    }

    public Class<? extends WebDriverConfiguration> getAlternativeWebDriverConfiguration() {
        return this.alternativeWebDriverConfiguration.get();
    }

    public void setAlternativeWebDriverConfiguration(Class<? extends WebDriverConfiguration> alternativeWebDriverConfiguration) {
        this.alternativeWebDriverConfiguration.set(alternativeWebDriverConfiguration);
    }

    public void resetAlternativeWebDriverConfiguration() {
        this.alternativeWebDriverConfiguration.set(null);
    }

    public WebDriverConfiguration getCurrentWebDriverConfiguration() {
        return Optional.ofNullable(this.alternativeWebDriverConfiguration.get()).map(this::getAlternativeWebDriverConfiguration).orElse(this.getDefaultWebDriverConfiguration());
    }

    public WebDriverConfiguration getAlternativeWebDriverConfiguration(Class<? extends WebDriverConfiguration> alternativeWebDriverConfigurationClass) {
        return this.webDriverConfigurations.stream().filter(webDriverConfiguration -> webDriverConfiguration.getClass().equals(alternativeWebDriverConfigurationClass)).findFirst().get();
    }

    public WebDriverConfiguration getDefaultWebDriverConfiguration() {
        return this.webDriverConfigurations.stream().filter(webDriverConfiguration -> webDriverConfiguration.getClass().equals(DEFAULT_WEB_DRIVER_CONFIGURATION)).findFirst().get();
    }

    public void loadWebdriver() {
        WebDriverConfiguration webDriverConfiguration = this.getCurrentWebDriverConfiguration();
        this.setDriver(webDriverConfiguration.loadWebdriver());
        webDriverConfiguration.afterLoad(this.webDriver.get());
    }

    public void quit() {
        if (this.webDriver.get() != null) {
            try {
                this.webDriver.get().quit();
            }
            catch (UnreachableBrowserException unreachableBrowserException) {
                log.error(unreachableBrowserException.getMessage());
            }
        }
        this.setDriver(null);
    }

    public boolean isClosed() {
        return this.webDriver.get() == null;
    }

    public String createScreenshot(String path) {
        try {
            log.info("Create screenshot to '{}'", (Object)path);
            if (this.webDriver.get() == null) {
                log.error("Can not create screenshot because webdriver is null!");
                return null;
            }
            if (this.webDriver.get() instanceof HtmlUnitDriver) {
                log.error("Can not create screenshots for htmlunit!");
                return null;
            }
            File screenshot = (File)((TakesScreenshot)this.webDriver.get()).getScreenshotAs(OutputType.FILE);
            File destFile = new File(path);
            FileUtils.copyFile((File)screenshot, (File)destFile);
            return destFile.getAbsolutePath();
        }
        catch (Exception e) {
            log.error("Exception at capture screenshot", (Throwable)e);
            return null;
        }
    }
}

