/*
 * Decompiled with CFR 0.152.
 */
package de.telekom.test.bddwebapp.frontend.element;

import de.telekom.test.bddwebapp.frontend.element.WebElementProxy;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WebElementEnhanced
extends WebElementProxy {
    public static List<String> NOT_INVOKE_WEB_ELEMENT_METHODS = Arrays.asList("setWebElement", "setWebDriver", "exists", "check");
    protected WebDriver webDriver;

    public WebElementEnhanced() {
    }

    public WebElementEnhanced(WebElement webElement, WebDriver webDriver) {
        super(webElement);
        this.webDriver = webDriver;
    }

    public void setWebDriver(WebDriver webDriver) {
        this.webDriver = webDriver;
    }

    public List<WebElementEnhanced> findElementsEnhanced(By by) {
        return this.webElement.findElements(by).stream().map(element -> new WebElementEnhanced((WebElement)element, this.webDriver)).collect(Collectors.toList());
    }

    public String getHtml() {
        return this.webElement.getAttribute("innerHTML");
    }

    public WebElementEnhanced findElementEnhanced(By by) {
        return new WebElementEnhanced(this.webElement.findElement(by), this.webDriver);
    }

    public void waitFor(Function<WebDriver, Boolean> function, int maxWaitTimeInSeconds, String errorMessage) {
        WebDriverWait webDriverWait = new WebDriverWait(this.webDriver, (long)maxWaitTimeInSeconds);
        webDriverWait.withMessage(errorMessage);
        webDriverWait.until(function);
    }

    public void waitForExisting(int maxWaitTimeInSeconds) {
        Function<WebDriver, Boolean> waitForExisting = driver -> this.exists();
        this.waitFor(waitForExisting, maxWaitTimeInSeconds, "Element still not exists!");
    }

    public void waitForDisplayed(int maxWaitTimeInSeconds) {
        Function<WebDriver, Boolean> waitForDisplayed = driver -> {
            try {
                return this.webElement.isDisplayed();
            }
            catch (WebDriverException e) {
                return false;
            }
        };
        this.waitFor(waitForDisplayed, maxWaitTimeInSeconds, "Element: \"" + this.webElement + "\" is still not displayed!");
    }

    public void scrollTo() {
        if (this.isJQueryAvailable()) {
            this.scrollToWithJQuery();
        } else {
            this.scrollToWithDefaultJavaScript();
        }
    }

    public boolean isJQueryAvailable() {
        return (Boolean)((JavascriptExecutor)this.webDriver).executeScript("return typeof jQuery != 'undefined'", new Object[]{this.webElement});
    }

    public void scrollToWithJQuery() {
        ((JavascriptExecutor)this.webDriver).executeScript("window.scrollTo(0, $(arguments[0]).offset().top - (window.innerHeight / 2))", new Object[]{this.webElement});
        this.waitForDisplayed(1);
    }

    public void scrollToWithDefaultJavaScript() {
        ((JavascriptExecutor)this.webDriver).executeScript("arguments[0].scrollIntoView(false);", new Object[]{this.webElement});
        this.waitForDisplayed(1);
        if (!this.isDisplayed()) {
            ((JavascriptExecutor)this.webDriver).executeScript("window.scrollTo(0, arguments[0]);", new Object[]{this.webElement});
            this.waitForDisplayed(1);
        }
    }

    public void click() {
        this.click(true);
    }

    public void click(boolean scrollTo) {
        if (scrollTo) {
            this.scrollTo();
        }
        this.webElement.click();
    }

    public void setValue(String value) {
        this.clear();
        this.sendKeys(value);
    }

    public boolean exists() {
        return this.check(o -> {
            WebElement webElement = this.getWebElement();
            webElement.isDisplayed();
            return o;
        });
    }

    public boolean hasChildren(By by) {
        return this.check(o -> this.webElement.findElement(by));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean check(Function check) {
        this.webDriver.manage().timeouts().implicitlyWait(100L, TimeUnit.MILLISECONDS);
        try {
            check.apply(Void.TYPE);
        }
        catch (NoSuchElementException | StaleElementReferenceException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.webDriver.manage().timeouts().implicitlyWait(3L, TimeUnit.SECONDS);
        }
        return true;
    }
}

