/*
 * Decompiled with CFR 0.152.
 */
package de.telekom.test.bddwebapp.interaction;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;

interface Interaction {
    public static final String OBJECT_KEY_SEPARATOR = ".";

    public void remember(String var1, Object var2);

    default public void remember(Enum key, Object value) {
        this.remember(key.toString(), value);
    }

    default public <S> S recall(String key) {
        return (S)this.getContext().get(key);
    }

    default public <S> S recall(Enum key) {
        return this.recall(key.toString());
    }

    default public <S> S recallNotNull(String key) {
        S value = this.recall(key);
        Assert.assertNotNull((String)String.format("Recalled '%s' for story interaction value '%s'", value, key), value);
        return value;
    }

    default public <S> S recallNotNull(Enum key) {
        return this.recallNotNull(key.toString());
    }

    public Map<String, Object> getContext();

    default public void rememberObject(String entityKey, String objectKey, Object value) {
        Object object = this.recall(entityKey);
        HashMap<String, Object> objectMap = object instanceof Map ? (HashMap<String, Object>)object : new HashMap<String, Object>();
        objectMap.put(objectKey, value);
        this.remember(entityKey, objectMap);
        if (object != null && !(object instanceof Map)) {
            this.remember(entityKey, object);
        }
    }

    default public void rememberObject(Enum entityKey, String objectKey, Object value) {
        this.rememberObject(entityKey.toString(), objectKey, value);
    }

    default public void rememberObject(String entityKey, Map<String, Object> object) {
        this.remember(entityKey, object);
    }

    default public void rememberObject(Enum entityKey, Map<String, Object> object) {
        this.remember(entityKey.toString(), object);
    }

    default public <S> S recallObject(String objectKey, String attributeKey) {
        String key = objectKey + OBJECT_KEY_SEPARATOR + attributeKey;
        return this.recall(key);
    }

    default public <S> S recallObjectNotNull(String objectKey, String attributeKey) {
        String key = objectKey + OBJECT_KEY_SEPARATOR + attributeKey;
        return this.recallNotNull(key);
    }

    default public <S> S recallObject(Enum objectKey, String attributeKey) {
        return this.recallObject(objectKey.toString(), attributeKey);
    }

    default public <S> S recallObjectNotNull(Enum objectKey, String attributeKey) {
        return this.recallObjectNotNull(objectKey.toString(), attributeKey);
    }

    default public <S> Map<String, S> recallMap(String key) {
        return (Map)this.recall(key);
    }

    default public <S> Map<String, S> recallMap(Enum key) {
        return (Map)this.recall(key.toString());
    }

    default public <S> Map<String, S> recallMapOrCreateNew(String key) {
        Map<String, S> map = this.recallMap(key);
        if (map == null) {
            this.remember(key, new HashMap());
        }
        return this.recallMap(key);
    }

    default public <S> Map<String, S> recallMapOrCreateNew(Enum key) {
        return this.recallMapOrCreateNew(key.toString());
    }

    default public <S> void rememberToList(String key, S value) {
        List<S> list = this.recallListOrCreateNew(key);
        list.add(value);
        this.remember(key, list);
    }

    default public <S> void rememberToList(Enum key, S value) {
        this.rememberToList(key.toString(), value);
    }

    default public <S> List<S> recallList(String key) {
        return (List)this.recall(key);
    }

    default public <S> List<S> recallList(Enum key) {
        return (List)this.recall(key);
    }

    default public <S> List<S> recallListOrCreateNew(String key) {
        List<S> list = this.recallList(key);
        if (list == null) {
            this.remember(key, new ArrayList());
        }
        return this.recallList(key);
    }

    default public <S> List<S> recallListOrCreateNew(Enum key) {
        return this.recallListOrCreateNew(key.toString());
    }

    default public void clear(String key) {
        this.remember(key, null);
    }

    default public void clear(Enum key) {
        this.clear(key.toString());
    }
}

