/*
 * Decompiled with CFR 0.152.
 */
package de.telekom.test.bddwebapp.interaction;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import de.telekom.test.bddwebapp.interaction.Interaction;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlatInteraction
implements Interaction {
    private static final Logger log = LoggerFactory.getLogger(FlatInteraction.class);
    public static String LIST_ITEM_FORMAT = "[%d]";
    protected Map<String, Object> context = Maps.newHashMap();

    public void startInteraction() {
        this.context = Maps.newHashMap();
    }

    public void stopInteraction() {
        this.startInteraction();
    }

    @Override
    public void remember(String key, Object value) {
        if (value instanceof Map) {
            ((Map)value).forEach((entryKey, entryValue) -> this.remember(key + "." + entryKey.toString(), entryValue));
        }
        if (value instanceof List) {
            List list = (List)value;
            for (int i = 0; i < list.size(); ++i) {
                this.remember(key + String.format(LIST_ITEM_FORMAT, i), list.get(i));
            }
        }
        this.context.put(key, value);
    }

    @Override
    public <S> S recall(String key) {
        Object s = this.getContext().get(key);
        if (s == null && key.contains(".")) {
            return this.recallByHierarchy(key);
        }
        return (S)s;
    }

    public <S> S recallByHierarchy(String key) {
        String[] paths;
        String objectKey;
        Object object;
        if (!(!key.contains(".") || (object = this.recall(objectKey = (paths = key.split("\\."))[0])) == null || object.getClass().isPrimitive() || object instanceof Map || object instanceof String || object instanceof Number)) {
            for (int i = 1; i < paths.length; ++i) {
                try {
                    object = FieldUtils.readField(object, (String)paths[i], (boolean)true);
                    continue;
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            return object;
        }
        return null;
    }

    public void logAllPossibleKeysWithValue() {
        log.info("Log all possible keys with value:");
        log.info(this.mapToString(this.context));
    }

    public void logAllPossibleKeysWithType() {
        log.info("Log all possible keys with type:");
        Map<String, Class> keysWithType = this.context.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> entry.getValue().getClass()));
        log.info(this.mapToString(keysWithType));
    }

    private String mapToString(Map<String, ?> map) {
        return Joiner.on((String)",\n").withKeyValueSeparator("=").join(map);
    }

    @Override
    public Map<String, Object> getContext() {
        return this.context;
    }
}

