/*
 * Decompiled with CFR 0.152.
 */
package de.telekom.test.bddwebapp.frontend.lifecycle;

import java.awt.GraphicsEnvironment;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.edge.EdgeOptions;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.ie.InternetExplorerOptions;
import org.openqa.selenium.opera.OperaDriver;
import org.openqa.selenium.opera.OperaOptions;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.safari.SafariDriver;
import org.openqa.selenium.safari.SafariOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface WebDriverConfiguration {
    default public WebDriver loadWebdriver() {
        String browser = this.getBrowser();
        this.getLogger().info("WebDriver is set to " + browser);
        DesiredCapabilities extraCapabilities = this.extraCapabilities(browser);
        if (this.isRemoteWebdriver()) {
            return this.loadRemoteWebdriver(extraCapabilities);
        }
        switch (browser.toLowerCase()) {
            case "firefox": {
                return this.loadFirefox(extraCapabilities);
            }
            case "chrome": {
                return this.loadChrome(extraCapabilities);
            }
            case "edge": {
                return this.loadEdge(extraCapabilities);
            }
            case "ie": 
            case "internetexplorer": {
                return this.loadInternetExplorer(extraCapabilities);
            }
            case "opera": {
                return this.loadOpera(extraCapabilities);
            }
            case "safari": {
                return this.loadSafari(extraCapabilities);
            }
            case "htmlunit": {
                return this.loadHtmlUnit(extraCapabilities);
            }
        }
        throw new IllegalArgumentException("No browser defined! Given browser is: " + browser);
    }

    default public DesiredCapabilities extraCapabilities(String browser) {
        return new DesiredCapabilities();
    }

    default public boolean isRemoteWebdriver() {
        return StringUtils.isNotBlank((CharSequence)this.getGridURL());
    }

    default public DesiredCapabilities remoteWebDriverOptions(DesiredCapabilities capabilities) {
        DesiredCapabilities remoteWebDriverCapabilities = new DesiredCapabilities();
        remoteWebDriverCapabilities.setJavascriptEnabled(true);
        remoteWebDriverCapabilities.merge((Capabilities)capabilities);
        return capabilities;
    }

    default public WebDriver loadRemoteWebdriver(DesiredCapabilities capabilities) {
        String gridURL = this.getGridURL();
        this.getLogger().info("Running on: " + gridURL);
        try {
            return new RemoteWebDriver(new URL(gridURL), (Capabilities)this.remoteWebDriverOptions(capabilities));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("URL for remote webdriver is malformed!", e);
        }
    }

    default public FirefoxOptions firefoxOptions(DesiredCapabilities capabilities) {
        FirefoxOptions firefoxOptions = new FirefoxOptions();
        if (this.isHeadless()) {
            this.getLogger().info("Firefox is set to headless mode");
            firefoxOptions.setHeadless(true);
        }
        firefoxOptions.merge((Capabilities)capabilities);
        return firefoxOptions;
    }

    default public WebDriver loadFirefox(DesiredCapabilities capabilities) {
        FirefoxOptions firefoxOptions = this.firefoxOptions(capabilities);
        String browserPath = this.getBrowserPath();
        if (StringUtils.isNotBlank((CharSequence)browserPath)) {
            this.getLogger().info("Load portable firefox instance from '{}'", (Object)browserPath);
            firefoxOptions.setBinary(browserPath);
        }
        return new FirefoxDriver(firefoxOptions);
    }

    default public ChromeOptions chromeOptions(DesiredCapabilities capabilities) {
        ChromeOptions chromeOptions = new ChromeOptions();
        if (this.isHeadless()) {
            this.getLogger().info("Chrome is set to headless mode");
            chromeOptions.setHeadless(true);
        }
        chromeOptions.merge((Capabilities)capabilities);
        return chromeOptions;
    }

    default public WebDriver loadChrome(DesiredCapabilities capabilities) {
        ChromeOptions chromeOptions = this.chromeOptions(capabilities);
        String browserPath = this.getBrowserPath();
        if (StringUtils.isNotBlank((CharSequence)browserPath)) {
            this.getLogger().info("Load portable chrome instance from '{}'", (Object)browserPath);
            chromeOptions.setBinary(browserPath);
        }
        return new ChromeDriver(chromeOptions);
    }

    default public EdgeOptions edgeOptions(DesiredCapabilities capabilities) {
        EdgeOptions edgeOptions = new EdgeOptions();
        if (this.isHeadless()) {
            this.getLogger().warn("No headless mode for edge available!");
        }
        edgeOptions.merge((Capabilities)capabilities);
        return edgeOptions;
    }

    default public WebDriver loadEdge(DesiredCapabilities capabilities) {
        EdgeOptions edgeOptions = this.edgeOptions(capabilities);
        String browserPath = this.getBrowserPath();
        if (StringUtils.isNotBlank((CharSequence)browserPath)) {
            throw new IllegalArgumentException("Can't use 'browserPath' for edge browser. Portable is not supported!");
        }
        return new EdgeDriver(edgeOptions);
    }

    default public InternetExplorerOptions internetExplorerOptions(DesiredCapabilities capabilities) {
        InternetExplorerOptions internetExplorerOptions = new InternetExplorerOptions();
        if (this.isHeadless()) {
            this.getLogger().warn("No headless mode for internet explorer available!");
        }
        internetExplorerOptions.merge((Capabilities)capabilities);
        return internetExplorerOptions;
    }

    default public WebDriver loadInternetExplorer(DesiredCapabilities capabilities) {
        InternetExplorerOptions internetExplorerOptions = this.internetExplorerOptions(capabilities);
        String browserPath = this.getBrowserPath();
        if (StringUtils.isNotBlank((CharSequence)browserPath)) {
            throw new IllegalArgumentException("Can't use 'browserPath' for Internet Explorer. Portable is not supported!");
        }
        return new InternetExplorerDriver(internetExplorerOptions);
    }

    default public OperaOptions operaOptions(DesiredCapabilities capabilities) {
        OperaOptions operaOptions = new OperaOptions();
        if (this.isHeadless()) {
            this.getLogger().warn("No headless mode for Opera available!");
        }
        operaOptions.merge((Capabilities)capabilities);
        return operaOptions;
    }

    default public WebDriver loadOpera(DesiredCapabilities capabilities) {
        OperaOptions operaOptions = this.operaOptions(capabilities);
        String browserPath = this.getBrowserPath();
        if (StringUtils.isNotBlank((CharSequence)browserPath)) {
            this.getLogger().info("Load portable opera instance from '{}'", (Object)browserPath);
            operaOptions.setBinary(browserPath);
        }
        return new OperaDriver(operaOptions);
    }

    default public SafariOptions safariOptions(DesiredCapabilities capabilities) {
        SafariOptions safariOptions = new SafariOptions();
        if (this.isHeadless()) {
            this.getLogger().warn("No headless mode for Safari available!");
        }
        safariOptions.merge((Capabilities)capabilities);
        return safariOptions;
    }

    default public WebDriver loadSafari(DesiredCapabilities capabilities) {
        SafariOptions safariOptions = this.safariOptions(capabilities);
        String browserPath = this.getBrowserPath();
        if (StringUtils.isNotBlank((CharSequence)browserPath)) {
            throw new IllegalArgumentException("Can't use 'browserPath' for Safari. Portable is not supported!");
        }
        return new SafariDriver(safariOptions);
    }

    default public DesiredCapabilities htmlUnitOptions(DesiredCapabilities capabilities) {
        DesiredCapabilities htmlUnitCapabilities = new DesiredCapabilities();
        htmlUnitCapabilities.setBrowserName("htmlunit");
        htmlUnitCapabilities.setJavascriptEnabled(true);
        htmlUnitCapabilities.merge((Capabilities)capabilities);
        return htmlUnitCapabilities;
    }

    default public WebDriver loadHtmlUnit(DesiredCapabilities capabilities) {
        return new HtmlUnitDriver((Capabilities)this.htmlUnitOptions(capabilities));
    }

    default public void afterLoad(WebDriver driver) {
    }

    default public String getBrowser() {
        String browser = System.getProperty("browser");
        if (StringUtils.isNotBlank((CharSequence)browser)) {
            return browser;
        }
        if (this.isHeadless()) {
            return "htmlunit";
        }
        return "chrome";
    }

    default public boolean isHeadless() {
        if (StringUtils.isNotBlank((CharSequence)System.getProperty("headless"))) {
            boolean headless = Boolean.valueOf(System.getProperty("headless"));
            this.getLogger().info(String.format("Test execution is set to headless=%s!", headless));
            return headless;
        }
        if (GraphicsEnvironment.isHeadless()) {
            this.getLogger().info("Headless execution detected! You can override this with \"headless=false\".");
            return true;
        }
        this.getLogger().info("Execution with graphical user interface detected! You can override this with \"headless=true\".");
        return false;
    }

    default public String getBrowserPath() {
        String browserPath = System.getProperty("browser.path");
        if (StringUtils.isNotBlank((CharSequence)browserPath)) {
            return browserPath;
        }
        return null;
    }

    default public String getGridURL() {
        String urlStr = System.getProperty("gridURL");
        if (StringUtils.isNotBlank((CharSequence)urlStr)) {
            return urlStr;
        }
        return null;
    }

    default public Logger getLogger() {
        return LoggerFactory.getLogger(WebDriverConfiguration.class);
    }
}

