/*
 * Decompiled with CFR 0.152.
 */
package de.telekom.test.bddwebapp.frontend.lifecycle;

import de.telekom.test.bddwebapp.frontend.lifecycle.WebDriverConfiguration;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class UsefulWebDriverConfiguration
implements WebDriverConfiguration {
    private static final Logger log = LoggerFactory.getLogger(UsefulWebDriverConfiguration.class);
    @Value(value="${webdriver.maximize:false}")
    private boolean maximizeBrowser;

    @Override
    public FirefoxOptions firefoxOptions(DesiredCapabilities capabilities) {
        FirefoxOptions firefoxOptions = new FirefoxOptions();
        if (this.isHeadless()) {
            this.getLogger().info("Firefox is set to headless mode");
            firefoxOptions.setHeadless(true);
        }
        capabilities.setCapability("overlappingCheckDisabled", true);
        firefoxOptions.merge((Capabilities)capabilities);
        return firefoxOptions;
    }

    @Override
    public ChromeOptions chromeOptions(DesiredCapabilities capabilities) {
        ChromeOptions chromeOptions = new ChromeOptions();
        if (this.isHeadless()) {
            this.getLogger().info("Chrome is set to headless mode");
            chromeOptions.setHeadless(true);
            chromeOptions.addArguments(new String[]{"--no-sandbox", "--disable-dev-shm-usage"});
        }
        capabilities.setCapability("disable-restore-session-state", true);
        capabilities.setCapability("disable-application-cache", true);
        capabilities.setCapability("useAutomationExtension", false);
        chromeOptions.merge((Capabilities)capabilities);
        return chromeOptions;
    }

    @Override
    public void afterLoad(WebDriver driver) {
        driver.manage().timeouts().implicitlyWait(5L, TimeUnit.SECONDS);
        driver.manage().timeouts().pageLoadTimeout(60L, TimeUnit.SECONDS);
        if (this.maximizeBrowser) {
            driver.manage().window().maximize();
        }
    }
}

