/*
 * Decompiled with CFR 0.152.
 */
package de.telekom.test.bddwebapp.frontend.lifecycle;

import de.telekom.test.bddwebapp.frontend.lifecycle.WebDriverConfiguration;
import de.telekom.test.bddwebapp.frontend.lifecycle.WebDriverWrapper;
import io.github.bonigarcia.wdm.DriverManagerType;
import io.github.bonigarcia.wdm.WebDriverManager;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class BrowserDriverUpdater {
    private static final Logger log = LoggerFactory.getLogger(BrowserDriverUpdater.class);
    @Value(value="${webdriver.proxy.host:#{null}}")
    private String proxyHost;
    @Value(value="${webdriver.proxy.port:#{null}}")
    private String proxyPort;
    @Autowired
    private WebDriverWrapper webDriverWrapper;

    public void updateDriver() {
        WebDriverConfiguration currentWebDriverConfiguration = this.webDriverWrapper.getCurrentWebDriverConfiguration();
        String browser = currentWebDriverConfiguration.getBrowser();
        DriverManagerType driverManagerType = this.mapToDriverManagerType(browser);
        if (driverManagerType == null) {
            log.info("No driver update available for " + browser + " browser");
            return;
        }
        log.info("Update driver for " + browser);
        WebDriverManager webDriverManager = WebDriverManager.getInstance((DriverManagerType)driverManagerType);
        if (StringUtils.isNotBlank((CharSequence)this.proxyHost) && StringUtils.isNotBlank((CharSequence)this.proxyPort)) {
            webDriverManager.proxy(this.proxyHost + ":" + this.proxyPort);
        }
        webDriverManager.setup();
        log.info("Updated instrumentalization driver for " + driverManagerType.toString() + "(" + browser + ")");
    }

    private DriverManagerType mapToDriverManagerType(String browser) {
        switch (browser.toLowerCase()) {
            case "firefox": {
                return DriverManagerType.FIREFOX;
            }
            case "chrome": {
                return DriverManagerType.CHROME;
            }
            case "edge": {
                return DriverManagerType.EDGE;
            }
            case "ie": 
            case "internetexplorer": {
                return DriverManagerType.IEXPLORER;
            }
            case "opera": {
                return DriverManagerType.OPERA;
            }
            case "phantomjs": {
                return DriverManagerType.PHANTOMJS;
            }
            case "standalone": 
            case "seleniumserverstandalone": {
                return DriverManagerType.SELENIUM_SERVER_STANDALONE;
            }
        }
        return null;
    }
}

