/*
 * Decompiled with CFR 0.152.
 */
package de.telekom.test.bddwebapp.stories.customizing;

import de.telekom.test.bddwebapp.frontend.lifecycle.WebDriverConfiguration;
import de.telekom.test.bddwebapp.steps.RestartBrowserBeforeScenario;
import de.telekom.test.bddwebapp.stories.config.AlternativeWebDriverConfiguration;
import de.telekom.test.bddwebapp.stories.customizing.CustomizingStories;
import java.util.Arrays;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CurrentStory {
    @Autowired
    private CustomizingStories customizingStories;
    private String storyPath;

    public String getStoryName() {
        if (this.storyPath == null) {
            return null;
        }
        return this.storyPath.substring(this.storyPath.lastIndexOf("/") + 1, this.storyPath.lastIndexOf("."));
    }

    public Class getStoryClass() {
        String storyName = this.getStoryName();
        if (storyName == null) {
            return null;
        }
        return this.customizingStories.getStoryClass(storyName);
    }

    public boolean isRestartBrowserBeforeScenario() {
        return this.isRestartBrowserBeforeScenarioForAllStories() || this.isRestartBrowserBeforeScenarioBaseType() || this.isRestartBrowserBeforeScenarioForCurrentStory();
    }

    private boolean isRestartBrowserBeforeScenarioForAllStories() {
        return this.customizingStories.isRestartBrowserBeforeScenarioForAllStories();
    }

    private boolean isRestartBrowserBeforeScenarioBaseType() {
        Class clazz = this.getStoryClass();
        return clazz != null && this.customizingStories.getRestartBrowserBeforeScenarioBaseType() != null && this.customizingStories.getRestartBrowserBeforeScenarioBaseType().isAssignableFrom(clazz);
    }

    private boolean isRestartBrowserBeforeScenarioForCurrentStory() {
        Class clazz = this.getStoryClass();
        return clazz != null && Arrays.stream(clazz.getAnnotations()).anyMatch(a -> a.annotationType().equals(RestartBrowserBeforeScenario.class));
    }

    public Optional<Class<? extends WebDriverConfiguration>> getAlternativeWebDriverConfiguration() {
        AlternativeWebDriverConfiguration alternativeWebDriverConfiguration;
        Class clazz = this.getStoryClass();
        if (clazz != null && (alternativeWebDriverConfiguration = clazz.getAnnotation(AlternativeWebDriverConfiguration.class)) != null) {
            return Optional.of(alternativeWebDriverConfiguration.value());
        }
        return Optional.empty();
    }

    public String getStoryPath() {
        return this.storyPath;
    }

    public void setStoryPath(String storyPath) {
        this.storyPath = storyPath;
    }
}

