/*
 * Decompiled with CFR 0.152.
 */
package de.telekom.test.bddwebapp.frontend.steps;

import de.telekom.test.bddwebapp.frontend.lifecycle.BrowserDriverUpdater;
import de.telekom.test.bddwebapp.frontend.lifecycle.WebDriverConfiguration;
import de.telekom.test.bddwebapp.frontend.lifecycle.WebDriverWrapper;
import de.telekom.test.bddwebapp.steps.Steps;
import de.telekom.test.bddwebapp.stories.customizing.CurrentStory;
import de.telekom.test.bddwebapp.stories.customizing.CustomizingStories;
import java.util.Optional;
import org.jbehave.core.annotations.AfterScenario;
import org.jbehave.core.annotations.AfterStories;
import org.jbehave.core.annotations.AfterStory;
import org.jbehave.core.annotations.BeforeStories;
import org.jbehave.core.annotations.BeforeStory;
import org.springframework.beans.factory.annotation.Autowired;

@Steps
public class WebDriverLifecycleSteps {
    @Autowired
    protected CurrentStory currentStory;
    @Autowired
    protected CustomizingStories customizingStories;
    @Autowired
    protected WebDriverWrapper webDriverWrapper;
    @Autowired
    protected BrowserDriverUpdater browserDriverUpdater;

    @BeforeStories
    public void updateDriver() {
        this.browserDriverUpdater.updateDriver();
    }

    @BeforeStory
    public void setAlternativeWebDriverConfiguration() {
        Optional<Class<? extends WebDriverConfiguration>> alternativeWebDriverConfiguration = this.currentStory.getAlternativeWebDriverConfiguration();
        if (alternativeWebDriverConfiguration.isPresent()) {
            this.webDriverWrapper.setAlternativeWebDriverConfiguration(alternativeWebDriverConfiguration.get());
        } else {
            this.webDriverWrapper.resetAlternativeWebDriverConfiguration();
        }
    }

    @AfterScenario
    public void quitBrowserAfterScenario() {
        if (this.currentStory.isRestartBrowserBeforeScenario()) {
            this.webDriverWrapper.quit();
        }
    }

    @AfterStory
    public void quitBrowserAfterStory() {
        this.webDriverWrapper.quit();
    }

    @AfterStories
    public void quitBrowserAfterStories() {
        this.webDriverWrapper.quit();
    }
}

