/*
 * Decompiled with CFR 0.152.
 */
package de.telekom.test.bddwebapp.frontend.lifecycle;

import de.telekom.test.bddwebapp.frontend.lifecycle.WebDriverConfiguration;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class UsefulWebDriverConfiguration
implements WebDriverConfiguration {
    private static final Logger log = LoggerFactory.getLogger(UsefulWebDriverConfiguration.class);
    @Value(value="${webdriver.maximize:false}")
    private boolean maximizeBrowser;

    @Override
    public WebDriver loadChrome(DesiredCapabilities capabilities) {
        ChromeOptions chromeOptions = new ChromeOptions();
        chromeOptions.setExperimentalOption("useAutomationExtension", (Object)false);
        chromeOptions.merge((Capabilities)capabilities);
        String browserPath = this.getBrowserPath();
        if (StringUtils.isNotBlank((CharSequence)browserPath)) {
            LoggerFactory.getLogger(WebDriverConfiguration.class).info("Load portable chrome instance from '{}'", (Object)browserPath);
            chromeOptions.setBinary(browserPath);
        }
        return new ChromeDriver(chromeOptions);
    }

    @Override
    public FirefoxOptions firefoxOptions(DesiredCapabilities capabilities) {
        FirefoxOptions firefoxOptions = new FirefoxOptions();
        capabilities.setCapability("overlappingCheckDisabled", true);
        firefoxOptions.merge((Capabilities)capabilities);
        return firefoxOptions;
    }

    @Override
    public ChromeOptions chromeOptions(DesiredCapabilities capabilities) {
        ChromeOptions chromeOptions = new ChromeOptions();
        capabilities.setCapability("disable-restore-session-state", true);
        capabilities.setCapability("disable-application-cache", true);
        capabilities.setCapability("useAutomationExtension", false);
        chromeOptions.merge((Capabilities)capabilities);
        return chromeOptions;
    }

    @Override
    public void afterLoad(WebDriver driver) {
        driver.manage().timeouts().implicitlyWait(5L, TimeUnit.SECONDS);
        driver.manage().timeouts().pageLoadTimeout(60L, TimeUnit.SECONDS);
        if (this.maximizeBrowser) {
            driver.manage().window().maximize();
        }
    }
}

