/*
 * Decompiled with CFR 0.152.
 */
package de.telekom.test.bddwebapp.stories.customizing;

import de.telekom.test.bddwebapp.stories.AbstractStory;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class CustomizingStories {
    private final Map<String, Class> storyClasses = new HashMap<String, Class>();
    private boolean apiOnlyForAllStories;
    private Class<? extends AbstractStory> apiOnlyBaseType;
    private boolean restartBrowserBeforeScenarioForAllStories;
    private Class<? extends AbstractStory> restartBrowserBeforeScenarioBaseType;

    public void setStoryClass(Class clazz, String name) {
        this.storyClasses.put(name, clazz);
    }

    public Class getStoryClass(String name) {
        return this.storyClasses.get(name);
    }

    public boolean storyClassesContainsOnlyApiOnlyStories() {
        return this.apiOnlyBaseType != null && this.storyClasses.values().stream().allMatch(storyClass -> storyClass.isAssignableFrom(this.apiOnlyBaseType));
    }

    public boolean isApiOnlyForAllStories() {
        return this.apiOnlyForAllStories;
    }

    public void setApiOnlyForAllStories(boolean apiOnlyForAllStories) {
        this.apiOnlyForAllStories = apiOnlyForAllStories;
    }

    public Class<? extends AbstractStory> getApiOnlyBaseType() {
        return this.apiOnlyBaseType;
    }

    public void setApiOnlyBaseType(Class<? extends AbstractStory> apiOnlyBaseType) {
        this.apiOnlyBaseType = apiOnlyBaseType;
    }

    public boolean isRestartBrowserBeforeScenarioForAllStories() {
        return this.restartBrowserBeforeScenarioForAllStories;
    }

    public void setRestartBrowserBeforeScenarioForAllStories(boolean restartBrowserBeforeScenarioForAllStories) {
        this.restartBrowserBeforeScenarioForAllStories = restartBrowserBeforeScenarioForAllStories;
    }

    public Class<? extends AbstractStory> getRestartBrowserBeforeScenarioBaseType() {
        return this.restartBrowserBeforeScenarioBaseType;
    }

    public void setRestartBrowserBeforeScenarioBaseType(Class<? extends AbstractStory> restartBrowserBeforeScenarioBaseType) {
        this.restartBrowserBeforeScenarioBaseType = restartBrowserBeforeScenarioBaseType;
    }
}

