/*
 * Decompiled with CFR 0.152.
 */
package de.telekom.test.bddwebapp.stories.customizing;

import de.telekom.test.bddwebapp.api.ApiOnly;
import de.telekom.test.bddwebapp.steps.RestartBrowserBeforeScenario;
import de.telekom.test.bddwebapp.stories.customizing.CustomizingStories;
import java.util.Arrays;
import lombok.NonNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CurrentStory {
    @NonNull
    private final CustomizingStories customizingStories;
    private String storyPath;

    public String getStoryName() {
        return this.storyPath.substring(this.storyPath.lastIndexOf("/") + 1, this.storyPath.lastIndexOf("."));
    }

    public Class getStoryClass() {
        return this.customizingStories.getStoryClass(this.getStoryName());
    }

    public boolean isApiOnly() {
        return this.isApiOnlyForAllStories() || this.isApiOnlyBaseType() || this.isApiOnlyAnnotationForCurrentStory();
    }

    private boolean isApiOnlyForAllStories() {
        return this.customizingStories.isApiOnlyForAllStories();
    }

    private boolean isApiOnlyBaseType() {
        Class clazz = this.getStoryClass();
        return clazz != null && this.customizingStories.getApiOnlyBaseType() != null && this.customizingStories.getApiOnlyBaseType().isAssignableFrom(clazz);
    }

    private boolean isApiOnlyAnnotationForCurrentStory() {
        Class clazz = this.getStoryClass();
        return clazz != null && Arrays.stream(clazz.getAnnotations()).anyMatch(a -> a.annotationType().equals(ApiOnly.class));
    }

    public boolean isRestartBrowserBeforeScenario() {
        return this.isRestartBrowserBeforeScenarioForAllStories() || this.isRestartBrowserBeforeScenarioBaseType() || this.isRestartBrowserBeforeScenarioForCurrentStory();
    }

    private boolean isRestartBrowserBeforeScenarioForAllStories() {
        return this.customizingStories.isRestartBrowserBeforeScenarioForAllStories();
    }

    private boolean isRestartBrowserBeforeScenarioBaseType() {
        Class clazz = this.getStoryClass();
        return clazz != null && this.customizingStories.getRestartBrowserBeforeScenarioBaseType() != null && this.customizingStories.getRestartBrowserBeforeScenarioBaseType().isAssignableFrom(clazz);
    }

    private boolean isRestartBrowserBeforeScenarioForCurrentStory() {
        Class clazz = this.getStoryClass();
        return clazz != null && Arrays.stream(clazz.getAnnotations()).anyMatch(a -> a.annotationType().equals(RestartBrowserBeforeScenario.class));
    }

    @Autowired
    public CurrentStory(@NonNull CustomizingStories customizingStories) {
        if (customizingStories == null) {
            throw new NullPointerException("customizingStories is marked @NonNull but is null");
        }
        this.customizingStories = customizingStories;
    }

    public String getStoryPath() {
        return this.storyPath;
    }

    public void setStoryPath(String storyPath) {
        this.storyPath = storyPath;
    }
}

