/*
 * Decompiled with CFR 0.152.
 */
package de.telekom.test.bddwebapp.steps;

import de.telekom.test.bddwebapp.interaction.StoryInteraction;
import de.telekom.test.bddwebapp.steps.Steps;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.jbehave.core.annotations.AsParameterConverter;
import org.jbehave.core.model.ExamplesTable;
import org.springframework.beans.factory.annotation.Autowired;

@Steps
public class StoryInteractionParameterConverter {
    public static String KEY_LITERAL = "$";
    public static String CONCATENATED_LITERAL = "+";
    @NonNull
    private final StoryInteraction storyInteraction;

    @AsParameterConverter
    public String getValueFromKeyOrValueOrConcatenated(String keyOrValueOrConcatenated) {
        if (this.isConcatenatedKey(keyOrValueOrConcatenated)) {
            return this.concatenatedKey(keyOrValueOrConcatenated);
        }
        return this.mapToValue(keyOrValueOrConcatenated);
    }

    public List<Map<String, String>> getRowsWithInteractionKey(ExamplesTable examplesTable) {
        List rows = examplesTable.getRows();
        rows.forEach(map -> map.entrySet().forEach(entry -> entry.setValue(this.getValueFromKeyOrValueOrConcatenated((String)entry.getValue()))));
        return rows;
    }

    protected boolean isKey(String keyOrValueOrConcatenated) {
        return keyOrValueOrConcatenated.startsWith(KEY_LITERAL);
    }

    protected boolean isConcatenatedKey(String keyOrValueOrConcatenated) {
        return keyOrValueOrConcatenated.contains(KEY_LITERAL) && keyOrValueOrConcatenated.contains(CONCATENATED_LITERAL);
    }

    protected String concatenatedKey(String concatenatedKey) {
        return Stream.of(concatenatedKey.split("\\" + CONCATENATED_LITERAL)).map(this::mapToValue).collect(Collectors.joining());
    }

    protected String mapToValue(String keyOrValueOrConcatenated) {
        if (this.isKey(keyOrValueOrConcatenated)) {
            return this.getStoryInteractionValue(keyOrValueOrConcatenated.substring(1));
        }
        return keyOrValueOrConcatenated;
    }

    protected String getStoryInteractionValue(String key) {
        String value = this.storyInteraction.recallNotNull(key).toString();
        if (value.startsWith("[") && value.endsWith("]")) {
            value = value.substring(1, value.length() - 1);
        }
        return value;
    }

    @Autowired
    public StoryInteractionParameterConverter(@NonNull StoryInteraction storyInteraction) {
        if (storyInteraction == null) {
            throw new NullPointerException("storyInteraction is marked @NonNull but is null");
        }
        this.storyInteraction = storyInteraction;
    }
}

