/*
 * Decompiled with CFR 0.152.
 */
package de.telekom.test.bddwebapp.steps;

import de.telekom.test.bddwebapp.frontend.lifecycle.BrowserDriverUpdater;
import de.telekom.test.bddwebapp.frontend.lifecycle.WebDriverWrapper;
import de.telekom.test.bddwebapp.interaction.ScenarioInteraction;
import de.telekom.test.bddwebapp.interaction.StoryInteraction;
import de.telekom.test.bddwebapp.steps.Steps;
import de.telekom.test.bddwebapp.stories.customizing.CurrentStory;
import de.telekom.test.bddwebapp.stories.customizing.CustomizingStories;
import lombok.NonNull;
import org.jbehave.core.annotations.AfterStories;
import org.jbehave.core.annotations.AfterStory;
import org.jbehave.core.annotations.BeforeScenario;
import org.jbehave.core.annotations.BeforeStories;
import org.jbehave.core.annotations.BeforeStory;
import org.jbehave.core.annotations.ScenarioType;
import org.springframework.beans.factory.annotation.Autowired;

@Steps
public class LifecycleSteps {
    public static final String CURRENT_PAGE = "CURRENT_PAGE";
    @NonNull
    protected final ScenarioInteraction scenarioInteraction;
    @NonNull
    protected final StoryInteraction storyInteraction;
    @NonNull
    protected final CurrentStory currentStory;
    @NonNull
    protected final CustomizingStories customizingStories;
    @NonNull
    protected final WebDriverWrapper webDriverWrapper;
    @NonNull
    protected final BrowserDriverUpdater browserDriverUpdater;

    @BeforeStories
    public void updateDriver() {
        if (!this.customizingStories.isApiOnlyForAllStories() && !this.customizingStories.storyClassesContainsOnlyApiOnlyStories()) {
            this.browserDriverUpdater.updateDriver();
        }
    }

    @BeforeStory
    public void startStoryInteraction() {
        this.storyInteraction.startInteraction();
        if (!this.currentStory.isRestartBrowserBeforeScenario() && !this.currentStory.isApiOnly()) {
            this.webDriverWrapper.loadWebdriver();
        }
    }

    @BeforeScenario(uponType=ScenarioType.NORMAL)
    public void setupScenarioInteractionForNormal() {
        this.setupScenarioInteraction();
    }

    @BeforeScenario(uponType=ScenarioType.EXAMPLE)
    public void setupScenarioInteractionForExample() {
        this.setupScenarioInteraction();
    }

    protected void setupScenarioInteraction() {
        this.scenarioInteraction.startInteraction();
        this.storyInteraction.setScenarioInteraction(this.scenarioInteraction);
        this.scenarioInteraction.setStoryInteraction(this.storyInteraction);
        if (this.currentStory.isRestartBrowserBeforeScenario()) {
            this.webDriverWrapper.quit();
            this.webDriverWrapper.loadWebdriver();
        }
    }

    @AfterStory
    public void afterStory() {
        this.webDriverWrapper.quit();
    }

    @AfterStories
    public void afterStories() {
        this.webDriverWrapper.quit();
    }

    @Autowired
    public LifecycleSteps(@NonNull ScenarioInteraction scenarioInteraction, @NonNull StoryInteraction storyInteraction, @NonNull CurrentStory currentStory, @NonNull CustomizingStories customizingStories, @NonNull WebDriverWrapper webDriverWrapper, @NonNull BrowserDriverUpdater browserDriverUpdater) {
        if (scenarioInteraction == null) {
            throw new NullPointerException("scenarioInteraction is marked @NonNull but is null");
        }
        if (storyInteraction == null) {
            throw new NullPointerException("storyInteraction is marked @NonNull but is null");
        }
        if (currentStory == null) {
            throw new NullPointerException("currentStory is marked @NonNull but is null");
        }
        if (customizingStories == null) {
            throw new NullPointerException("customizingStories is marked @NonNull but is null");
        }
        if (webDriverWrapper == null) {
            throw new NullPointerException("webDriverWrapper is marked @NonNull but is null");
        }
        if (browserDriverUpdater == null) {
            throw new NullPointerException("browserDriverUpdater is marked @NonNull but is null");
        }
        this.scenarioInteraction = scenarioInteraction;
        this.storyInteraction = storyInteraction;
        this.currentStory = currentStory;
        this.customizingStories = customizingStories;
        this.webDriverWrapper = webDriverWrapper;
        this.browserDriverUpdater = browserDriverUpdater;
    }
}

