/*
 * Decompiled with CFR 0.152.
 */
package de.telekom.test.bddwebapp.interaction;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import de.telekom.test.bddwebapp.api.RequestBuilder;
import de.telekom.test.bddwebapp.interaction.FlatInteraction;
import de.telekom.test.bddwebapp.interaction.StoryInteraction;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ScenarioInteraction
extends FlatInteraction {
    private static final String BODY = "BODY";
    private static final String PATH_PARAMS = "PATH_PARAMS";
    private static final String QUERY_PARAMS = "QUERY_PARAMS";
    private StoryInteraction storyInteraction;
    @Autowired
    private RequestBuilder requestBuilder;

    public List<Object> arrayBody() {
        Object body = this.recall(BODY);
        if (body == null) {
            this.remember(BODY, (Object)Lists.newArrayList());
        }
        return (List)this.recallNotNull(BODY);
    }

    @Override
    public void startInteraction() {
        super.startInteraction();
        this.requestBuilder.clearRequest();
    }

    public Map<String, Object> mapBody() {
        return this.getMapFromStoryInteraction(BODY);
    }

    public Map<String, String> mapPathParam() {
        return this.getMapFromStoryInteraction(PATH_PARAMS);
    }

    public Map<String, String> mapQueryParam() {
        return this.getMapFromStoryInteraction(QUERY_PARAMS);
    }

    public <T> Map<String, T> getMapFromStoryInteraction(String queryParams) {
        Object body = this.recall(queryParams);
        if (body == null) {
            this.remember(queryParams, (Object)Maps.newHashMap());
        }
        return (Map)this.recallNotNull(queryParams);
    }

    public void rememberFromStoryInteraction(String key) {
        super.remember(key, this.storyInteraction.recallNotNull(key));
    }

    public void rememberObjectFromStoryInteraction(String entityKey, String objectKey) {
        super.rememberObject(entityKey, objectKey, this.storyInteraction.recallObjectNotNull(entityKey, objectKey));
    }

    public void setStoryInteraction(StoryInteraction storyInteraction) {
        this.storyInteraction = storyInteraction;
    }
}

