/*
 * Decompiled with CFR 0.152.
 */
package de.telekom.test.bddwebapp.interaction;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import de.telekom.test.bddwebapp.interaction.Interaction;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FlatInteraction
implements Interaction {
    private static final Logger log = LoggerFactory.getLogger(FlatInteraction.class);
    private static String LIST_ITEM_FORMAT = "[%d]";
    protected Map<String, Object> context = Maps.newHashMap();

    public void startInteraction() {
        this.context = Maps.newHashMap();
    }

    public void stopInteraction() {
        this.startInteraction();
    }

    @Override
    public void remember(String key, Object value) {
        if (value instanceof Map) {
            ((Map)value).forEach((entryKey, entryValue) -> this.remember(key + "." + entryKey.toString(), entryValue));
        }
        if (value instanceof List) {
            List list = (List)value;
            for (int i = 0; i < list.size(); ++i) {
                this.remember(key + String.format(LIST_ITEM_FORMAT, i), list.get(i));
            }
        }
        this.context.put(key, value);
    }

    public void logAllPossibleKeysWithType() {
        this.carefulHint("logAllPossibleKeysWithType()");
        Map<String, Class> keysWithType = this.context.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> entry.getValue().getClass()));
        log.info("\n" + this.mapToString(keysWithType));
    }

    public void logAllPossibleKeysWithValue() {
        this.carefulHint("logAllPossibleKeysWithValue()");
        log.info("\n" + this.mapToString(this.context));
    }

    private void carefulHint(String method) {
        log.info("\n==============================================================================================\nBe careful with " + method + ". The log can get very large. Use only for debugging purposes!\n==============================================================================================");
    }

    private String mapToString(Map<String, ?> map) {
        return Joiner.on((String)",\n").withKeyValueSeparator("=").join(map);
    }

    @Override
    public Map<String, Object> getContext() {
        return this.context;
    }
}

