/*
 * Decompiled with CFR 0.152.
 */
package de.telekom.test.bddwebapp.frontend.steps;

import com.google.common.collect.Maps;
import de.telekom.test.bddwebapp.frontend.element.decorator.WebElementDecorator;
import de.telekom.test.bddwebapp.frontend.lifecycle.WebDriverWrapper;
import de.telekom.test.bddwebapp.frontend.page.Page;
import de.telekom.test.bddwebapp.interaction.ScenarioInteraction;
import de.telekom.test.bddwebapp.interaction.StoryInteraction;
import de.telekom.test.bddwebapp.steps.LifecycleSteps;
import de.telekom.test.bddwebapp.steps.StoryInteractionParameterConverter;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.PageFactory;
import org.openqa.selenium.support.pagefactory.FieldDecorator;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class SeleniumSteps {
    private static final String QUERY_PARAMS = "QUERY_PARAMS";
    @Autowired
    protected WebDriverWrapper webDriverWrapper;
    @Autowired
    protected StoryInteraction storyInteraction;
    @Autowired
    protected ScenarioInteraction scenarioInteraction;
    @Autowired
    protected LifecycleSteps lifecyleSteps;
    @Autowired
    protected StoryInteractionParameterConverter storyInteractionParameterConverter;

    protected synchronized <T extends Page> T createExpectedPage(Class<T> expectedPage) {
        Page page;
        WebDriver driver = this.webDriverWrapper.getDriver();
        try {
            page = (Page)expectedPage.getConstructor(WebDriver.class).newInstance(driver);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        PageFactory.initElements((FieldDecorator)new WebElementDecorator(driver), (Object)page);
        this.storyInteraction.remember("CURRENT_PAGE", (Object)page);
        return (T)page;
    }

    protected <T extends Page> T getCurrentPage() {
        return (T)((Page)this.storyInteraction.recall("CURRENT_PAGE"));
    }

    protected String getUrlWithHost(String hostIncludingPort, String path) {
        return this.appendUrl(hostIncludingPort, path);
    }

    protected String getUrlWithHost(String hostIncludingPort, String contextPath, String path) {
        return this.appendUrl(hostIncludingPort, contextPath, path);
    }

    protected String getUrlWithHost(String hostIncludingPort, String contextPath, String path, Map<String, String> queryParams) {
        String url = this.appendUrl(hostIncludingPort, contextPath, path);
        return this.appendQueryParams(url, queryParams);
    }

    protected void open(String url) {
        WebDriver driver = this.webDriverWrapper.getDriver();
        driver.get(url);
    }

    protected String appendQueryParams(String url, Map<String, String> queryParams) {
        if (queryParams != null && queryParams.size() > 0) {
            StringBuilder query = new StringBuilder();
            boolean isFirstparameter = true;
            for (String key : queryParams.keySet()) {
                if (isFirstparameter) {
                    isFirstparameter = false;
                } else {
                    query.append("&");
                }
                String value = queryParams.get(key);
                if (StringUtils.isEmpty((CharSequence)value)) {
                    query.append(key);
                    continue;
                }
                query.append(key).append("=").append(value);
            }
            url = url + "?" + query;
        }
        return url;
    }

    protected String appendUrl(String url, String ... appenders) {
        StringBuilder urlBuilder = new StringBuilder(url);
        for (String appender : appenders) {
            boolean alreadyAppended = false;
            if (urlBuilder.toString().endsWith("/") && appender.startsWith("/")) {
                urlBuilder.append(StringUtils.substring((String)appender, (int)1));
                alreadyAppended = true;
            }
            if (alreadyAppended) continue;
            if (urlBuilder.toString().endsWith("/") || appender.startsWith("/")) {
                urlBuilder.append(appender);
                continue;
            }
            urlBuilder.append("/").append(appender);
        }
        url = urlBuilder.toString();
        return url;
    }

    protected Map<String, String> mapQueryParam() {
        return this.getMapFromStoryInteraction();
    }

    protected <T> Map<String, T> getMapFromStoryInteraction() {
        Object body = this.scenarioInteraction.recall(QUERY_PARAMS);
        if (body == null) {
            this.scenarioInteraction.remember(QUERY_PARAMS, (Object)Maps.newHashMap());
        }
        return (Map)this.scenarioInteraction.recallNotNull(QUERY_PARAMS);
    }
}

