/*
 * Decompiled with CFR 0.152.
 */
package de.telekom.test.bddwebapp.frontend.screenshot;

import de.telekom.test.bddwebapp.frontend.lifecycle.WebDriverWrapper;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.Date;
import java.util.stream.IntStream;
import javax.imageio.ImageIO;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.jbehave.core.reporters.StoryReporterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScreenshotCreator {
    private static final Logger log = LoggerFactory.getLogger(ScreenshotCreator.class);
    protected static String SCREENSHOT_PATH = "{0}/screenshots/{1}/{2}.png";
    @NonNull
    protected final StoryReporterBuilder reporterBuilder;
    @NonNull
    protected final WebDriverWrapper webDriverWrapper;

    public String createScreenshot(String storyFolder, String step, String status) {
        if (this.webDriverWrapper.getDriver() == null) {
            log.debug("No failure screenshot was taken because WebDriver is null. Maybe the WebDriver was closed or the current story is in ApiOnly mode");
            return null;
        }
        try {
            log.info(MessageFormat.format("Make Screenshot for story folder: \"{0}\" step: \"{1}\"", storyFolder, step));
            String screenshotName = this.screenshotName(step, status);
            String screenshotPath = MessageFormat.format(SCREENSHOT_PATH, this.reporterBuilder.outputDirectory(), storyFolder, screenshotName);
            screenshotPath = this.webDriverWrapper.createScreenshot(screenshotPath);
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{screenshotPath}) && this.screenshotIsNotEmpty(screenshotPath)) {
                return this.screenshotUrl(storyFolder, step, screenshotName, screenshotPath);
            }
        }
        catch (Exception e) {
            log.error(MessageFormat.format("Screenshot failed for story folder: \"{0}\" step: \"{1}\"", storyFolder, step));
        }
        return null;
    }

    protected String screenshotName(String step, String status) {
        step = step.replaceAll("\\s", "_");
        step = step.replaceAll("\"[.*\"]", "");
        return step + "_" + new Date().getTime() + "_" + status;
    }

    protected boolean screenshotIsNotEmpty(String screenshotPath) {
        try {
            BufferedImage bufferedImage = ImageIO.read(new FileInputStream(screenshotPath));
            Raster raster = bufferedImage.getData();
            return !IntStream.range(0, raster.getWidth()).noneMatch(x -> IntStream.range(0, raster.getHeight()).anyMatch(y -> bufferedImage.getRGB(x, y) != -1));
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    protected String screenshotUrl(String storyFolder, String step, String screenshotName, String screenshotPath) {
        String urlPath;
        try {
            urlPath = new URL(this.webDriverWrapper.getDriver().getCurrentUrl()).getPath();
        }
        catch (Exception e) {
            urlPath = "[unknown url]";
        }
        log.info(MessageFormat.format("Screenshot of step \"{0}\" with url \"{1}\" has been saved to \"{2}\"", step, urlPath, screenshotPath));
        try {
            screenshotName = URLEncoder.encode(screenshotName, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("Exception at screenshot name url encoding", (Throwable)e);
        }
        return MessageFormat.format(SCREENSHOT_PATH, "..", storyFolder, screenshotName);
    }

    public ScreenshotCreator(@NonNull StoryReporterBuilder reporterBuilder, @NonNull WebDriverWrapper webDriverWrapper) {
        if (reporterBuilder == null) {
            throw new NullPointerException("reporterBuilder is marked @NonNull but is null");
        }
        if (webDriverWrapper == null) {
            throw new NullPointerException("webDriverWrapper is marked @NonNull but is null");
        }
        this.reporterBuilder = reporterBuilder;
        this.webDriverWrapper = webDriverWrapper;
    }
}

