/*
 * Decompiled with CFR 0.152.
 */
package de.telekom.test.bddwebapp.frontend.lifecycle;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.edge.EdgeOptions;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.ie.InternetExplorerOptions;
import org.openqa.selenium.opera.OperaDriver;
import org.openqa.selenium.opera.OperaOptions;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.UnreachableBrowserException;
import org.openqa.selenium.safari.SafariDriver;
import org.openqa.selenium.safari.SafariOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class WebDriverWrapper {
    private static final Logger log = LoggerFactory.getLogger(WebDriverWrapper.class);
    @Value(value="${default.browser:chrome}")
    private String defaultBrowser;
    @Value(value="${browser.path:#{null}}")
    private String browserPath;
    @Value(value="${webdriver.proxy.host:#{null}}")
    private String proxyHost;
    @Value(value="${webdriver.proxy.port:#{null}}")
    private String proxyPort;
    @Value(value="${webdriver.maximize:false}")
    private boolean maximizeBrowser;
    private WebDriver driver;

    public void loadWebdriver() {
        String browser = this.getBrowser();
        DesiredCapabilities capabilities = this.capabilities(browser);
        String gridURL = this.getGridURL();
        if (StringUtils.isBlank((CharSequence)gridURL)) {
            this.loadLocalWebdriver(browser, capabilities);
        } else {
            this.loadRemoteWebdriver(gridURL, capabilities);
        }
        this.afterLoad();
    }

    protected DesiredCapabilities capabilities(String browser) {
        switch (browser.toLowerCase()) {
            case "firefox": {
                return this.firefoxCapabilities();
            }
            case "chrome": {
                return this.chromeCapabilities();
            }
            case "edge": {
                return this.edgeCapabilities();
            }
            case "ie": {
                return this.ieCapabilities();
            }
            case "opera": {
                return this.operaCapabilities();
            }
            case "safari": {
                return this.safariCapabilities();
            }
            case "htmlunit": {
                return this.htmlUnitCapabilities();
            }
        }
        throw new IllegalArgumentException("No browser defined! Given browser is: " + browser);
    }

    protected DesiredCapabilities firefoxCapabilities() {
        DesiredCapabilities desiredCapabilities = DesiredCapabilities.firefox();
        desiredCapabilities.setCapability("overlappingCheckDisabled", true);
        return desiredCapabilities;
    }

    protected DesiredCapabilities chromeCapabilities() {
        DesiredCapabilities desiredCapabilities = DesiredCapabilities.chrome();
        desiredCapabilities.setCapability("disable-restore-session-state", true);
        desiredCapabilities.setCapability("disable-application-cache", true);
        desiredCapabilities.setCapability("useAutomationExtension", false);
        return desiredCapabilities;
    }

    protected DesiredCapabilities edgeCapabilities() {
        return DesiredCapabilities.edge();
    }

    protected DesiredCapabilities ieCapabilities() {
        DesiredCapabilities desiredCapabilities = DesiredCapabilities.internetExplorer();
        desiredCapabilities.setCapability("ignoreProtectedModeSettings", true);
        desiredCapabilities.setCapability("nativeEvents", true);
        desiredCapabilities.setCapability("applicationCacheEnabled", true);
        desiredCapabilities.setCapability("cssSelectorsEnabled", true);
        desiredCapabilities.setCapability("javascriptEnabled", true);
        desiredCapabilities.setCapability("locationContextEnabled", true);
        desiredCapabilities.setCapability("databaseEnabled", true);
        desiredCapabilities.setCapability("webStorageEnabled", true);
        desiredCapabilities.setCapability("acceptSslCerts", true);
        return desiredCapabilities;
    }

    protected DesiredCapabilities operaCapabilities() {
        return DesiredCapabilities.operaBlink();
    }

    private DesiredCapabilities safariCapabilities() {
        return DesiredCapabilities.safari();
    }

    private DesiredCapabilities htmlUnitCapabilities() {
        return DesiredCapabilities.htmlUnit();
    }

    protected void loadLocalWebdriver(String browser, DesiredCapabilities capabilities) {
        log.info("Browser is set to: " + browser);
        switch (browser.toLowerCase()) {
            case "firefox": {
                this.loadFirefox(capabilities);
                return;
            }
            case "chrome": {
                this.loadChrome(capabilities);
                return;
            }
            case "edge": {
                this.loadEdge(capabilities);
                return;
            }
            case "ie": {
                this.loadInternetExplorer(capabilities);
                return;
            }
            case "opera": {
                this.loadOpera(capabilities);
                break;
            }
            case "safari": {
                this.loadSafari(capabilities);
                return;
            }
            case "htmlunit": {
                this.loadHtmlUnit(capabilities);
                return;
            }
            default: {
                throw new IllegalArgumentException("No browser defined! Given browser is: " + browser);
            }
        }
    }

    protected void loadFirefox(DesiredCapabilities capabilities) {
        FirefoxOptions firefoxOptions = new FirefoxOptions((Capabilities)capabilities);
        if (StringUtils.isNotBlank((CharSequence)this.browserPath)) {
            log.info("Load portable firefox instance from '{}'", (Object)this.browserPath);
            firefoxOptions.setBinary(this.browserPath);
        }
        this.driver = new FirefoxDriver(firefoxOptions);
    }

    protected void loadChrome(DesiredCapabilities capabilities) {
        ChromeOptions chromeOptions = new ChromeOptions();
        chromeOptions.setExperimentalOption("useAutomationExtension", (Object)false);
        chromeOptions.merge((Capabilities)capabilities);
        if (StringUtils.isNotBlank((CharSequence)this.browserPath)) {
            log.info("Load portable chrome instance from '{}'", (Object)this.browserPath);
            chromeOptions.setBinary(this.browserPath);
        }
        this.driver = new ChromeDriver(chromeOptions);
    }

    protected void loadEdge(DesiredCapabilities capabilities) {
        EdgeOptions edgeOptions = new EdgeOptions();
        edgeOptions.merge((Capabilities)capabilities);
        if (StringUtils.isNotBlank((CharSequence)this.browserPath)) {
            throw new IllegalArgumentException("Can't use 'browserPath' for edge browser. Portable is not supported!");
        }
        this.driver = new EdgeDriver(edgeOptions);
    }

    protected void loadInternetExplorer(DesiredCapabilities capabilities) {
        InternetExplorerOptions internetExplorerOptions = new InternetExplorerOptions((Capabilities)capabilities);
        if (StringUtils.isNotBlank((CharSequence)this.browserPath)) {
            throw new IllegalArgumentException("Can't use 'browserPath' for Internet Explorer. Portable is not supported!");
        }
        this.driver = new InternetExplorerDriver(internetExplorerOptions);
    }

    private void loadOpera(DesiredCapabilities capabilities) {
        OperaOptions operaOptions = new OperaOptions();
        operaOptions.merge((Capabilities)capabilities);
        if (StringUtils.isNotBlank((CharSequence)this.browserPath)) {
            log.info("Load portable opera instance from '{}'", (Object)this.browserPath);
            operaOptions.setBinary(this.browserPath);
        }
        this.driver = new OperaDriver(operaOptions);
    }

    protected void loadSafari(DesiredCapabilities capabilities) {
        SafariOptions safariOptions = new SafariOptions();
        safariOptions.merge((Capabilities)capabilities);
        if (StringUtils.isNotBlank((CharSequence)this.browserPath)) {
            throw new IllegalArgumentException("Can't use 'browserPath' for Safari. Portable is not supported!");
        }
        this.driver = new SafariDriver(safariOptions);
    }

    private void loadHtmlUnit(DesiredCapabilities capabilities) {
        HtmlUnitDriver htmlUnitDriver = new HtmlUnitDriver((Capabilities)capabilities);
        htmlUnitDriver.setJavascriptEnabled(true);
        this.driver = htmlUnitDriver;
    }

    protected void loadRemoteWebdriver(String gridURL, DesiredCapabilities capabilities) {
        log.info("Running on: " + gridURL);
        try {
            this.driver = new RemoteWebDriver(new URL(gridURL), (Capabilities)capabilities);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("URL for remote webdriver is malformed!", e);
        }
    }

    protected String getBrowser() {
        String browser = System.getProperty("browser");
        if (StringUtils.isNotBlank((CharSequence)browser)) {
            return browser;
        }
        return this.defaultBrowser;
    }

    protected String getGridURL() {
        String urlStr = System.getProperty("gridURL");
        if (StringUtils.isNotBlank((CharSequence)urlStr)) {
            return urlStr;
        }
        return null;
    }

    protected void afterLoad() {
        this.driver.manage().timeouts().implicitlyWait(5L, TimeUnit.SECONDS);
        this.driver.manage().timeouts().pageLoadTimeout(60L, TimeUnit.SECONDS);
        if (this.maximizeBrowser) {
            this.driver.manage().window().maximize();
        }
    }

    public void quit() {
        if (this.driver != null) {
            try {
                this.driver.quit();
            }
            catch (UnreachableBrowserException unreachableBrowserException) {
                log.error(unreachableBrowserException.getMessage());
            }
        }
        this.driver = null;
    }

    public boolean isClosed() {
        return this.driver == null;
    }

    public String createScreenshot(String path) {
        try {
            log.info("Create screenshot to '{}'", (Object)path);
            if (this.driver == null) {
                log.error("Can not create screenshot because webdriver is null!");
                return null;
            }
            if (this.driver instanceof HtmlUnitDriver) {
                log.error("Can not create screenshots for htmlunit!");
                return null;
            }
            File screenshot = (File)((TakesScreenshot)this.driver).getScreenshotAs(OutputType.FILE);
            File destFile = new File(path);
            FileUtils.copyFile((File)screenshot, (File)destFile);
            return destFile.getAbsolutePath();
        }
        catch (Exception e) {
            log.error("Exception at capture screenshot", (Throwable)e);
            return null;
        }
    }

    public WebDriver getDriver() {
        return this.driver;
    }

    public void setDriver(WebDriver driver) {
        this.driver = driver;
    }
}

