/*
 * Decompiled with CFR 0.152.
 */
package de.telekom.test.bddwebapp.frontend.lifecycle;

import de.telekom.test.bddwebapp.frontend.lifecycle.WebDriverWrapper;
import io.github.bonigarcia.wdm.ChromeDriverManager;
import io.github.bonigarcia.wdm.DriverManagerType;
import io.github.bonigarcia.wdm.EdgeDriverManager;
import io.github.bonigarcia.wdm.FirefoxDriverManager;
import io.github.bonigarcia.wdm.InternetExplorerDriverManager;
import io.github.bonigarcia.wdm.OperaDriverManager;
import io.github.bonigarcia.wdm.PhantomJsDriverManager;
import io.github.bonigarcia.wdm.SeleniumServerStandaloneManager;
import io.github.bonigarcia.wdm.WebDriverManager;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class BrowserDriverUpdater {
    private static final Logger log = LoggerFactory.getLogger(BrowserDriverUpdater.class);
    @Value(value="${webdriver.proxy.host:#{null}}")
    private String proxyHost;
    @Value(value="${webdriver.proxy.port:#{null}}")
    private String proxyPort;
    @NonNull
    private final WebDriverWrapper webDriverWrapper;

    public void updateDriver() {
        WebDriverManager webDriverManager;
        String browser = this.webDriverWrapper.getBrowser();
        switch (browser.toLowerCase()) {
            case "firefox": {
                webDriverManager = FirefoxDriverManager.getInstance((DriverManagerType)DriverManagerType.FIREFOX);
                break;
            }
            case "chrome": {
                System.setProperty("webdriver.chrome.logfile", "chromedriver.log");
                webDriverManager = ChromeDriverManager.getInstance((DriverManagerType)DriverManagerType.CHROME);
                break;
            }
            case "edge": {
                webDriverManager = EdgeDriverManager.getInstance((DriverManagerType)DriverManagerType.EDGE);
                break;
            }
            case "ie": {
                webDriverManager = InternetExplorerDriverManager.getInstance((DriverManagerType)DriverManagerType.IEXPLORER);
                break;
            }
            case "opera": {
                webDriverManager = OperaDriverManager.getInstance((DriverManagerType)DriverManagerType.OPERA);
                break;
            }
            case "phantomjs": {
                webDriverManager = PhantomJsDriverManager.getInstance((DriverManagerType)DriverManagerType.PHANTOMJS);
                break;
            }
            case "seleniumserverstandalone": {
                webDriverManager = SeleniumServerStandaloneManager.getInstance((DriverManagerType)DriverManagerType.SELENIUM_SERVER_STANDALONE);
                break;
            }
            default: {
                return;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.proxyHost) && StringUtils.isNotBlank((CharSequence)this.proxyPort)) {
            webDriverManager.proxy(this.proxyHost + ":" + this.proxyPort);
        }
        webDriverManager.setup();
        log.info("Updated driver for " + browser + " test instrumentalization.");
    }

    @Autowired
    public BrowserDriverUpdater(@NonNull WebDriverWrapper webDriverWrapper) {
        if (webDriverWrapper == null) {
            throw new NullPointerException("webDriverWrapper is marked @NonNull but is null");
        }
        this.webDriverWrapper = webDriverWrapper;
    }
}

