/*
 * Decompiled with CFR 0.152.
 */
package de.telekom.test.bddwebapp.frontend.element.decorator;

import de.telekom.test.bddwebapp.frontend.element.WebElementEnhanced;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.pagefactory.ElementLocator;
import org.springframework.beans.factory.annotation.Autowired;

public class WebElementHandler
implements MethodInterceptor {
    private static final List<String> IGNORED_METHODS = Arrays.asList("toString", "hashCode");
    private final WebDriver webDriver;
    private final ElementLocator locator;

    public Object intercept(Object o, Method method, Object[] objects, MethodProxy methodProxy) throws Throwable {
        if (IGNORED_METHODS.contains(method.getName())) {
            return methodProxy.invokeSuper(o, objects);
        }
        if (o instanceof WebElementEnhanced) {
            return this.invokeWebElementEnhanced(o, method, objects, methodProxy);
        }
        if (o instanceof List) {
            return this.invokeListContainingWebElementEnhanced(objects, methodProxy);
        }
        return null;
    }

    private Object invokeWebElementEnhanced(Object o, Method method, Object[] objects, MethodProxy methodProxy) throws Throwable {
        WebElementEnhanced webElementEnhanced = (WebElementEnhanced)o;
        if (!"setWebDriver".equals(method.getName())) {
            webElementEnhanced.setWebDriver(this.webDriver);
        }
        if (!WebElementEnhanced.NOT_INVOKE_WEB_ELEMENT_METHODS.contains(method.getName())) {
            WebElement element = this.locator.findElement();
            webElementEnhanced.setWebElement(element);
        }
        try {
            return methodProxy.invokeSuper(o, objects);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    private Object invokeListContainingWebElementEnhanced(Object[] objects, MethodProxy methodProxy) throws Throwable {
        List webElementEnhanceds = this.locator.findElements().stream().map(webElement -> {
            WebElementEnhanced webElementEnhanced = new WebElementEnhanced();
            webElementEnhanced.setWebElement((WebElement)webElement);
            webElementEnhanced.setWebDriver(this.webDriver);
            return webElementEnhanced;
        }).collect(Collectors.toList());
        try {
            return methodProxy.invoke(webElementEnhanceds, objects);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    @Autowired
    public WebElementHandler(WebDriver webDriver, ElementLocator locator) {
        this.webDriver = webDriver;
        this.locator = locator;
    }
}

