/*
 * Decompiled with CFR 0.152.
 */
package de.telekom.test.bddwebapp.frontend.element;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Point;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WebElementEnhanced {
    public static List<String> NOT_INVOKE_WEB_ELEMENT_METHODS = Arrays.asList("setWebElement", "setWebDriver", "exists", "check");
    protected WebElement webElement;
    protected WebDriver webDriver;

    public WebElementEnhanced() {
    }

    public WebElementEnhanced(WebElement webElement) {
        this.webElement = webElement;
    }

    public WebElementEnhanced(WebElement webElement, WebDriver webDriver) {
        this.webElement = webElement;
        this.webDriver = webDriver;
    }

    public WebElement getWebElement() {
        return this.webElement;
    }

    public void setWebElement(WebElement webElement) {
        this.webElement = webElement;
    }

    public void setWebDriver(WebDriver webDriver) {
        this.webDriver = webDriver;
    }

    public void sendKeys(CharSequence ... keysToSend) {
        this.webElement.sendKeys(keysToSend);
    }

    public Point getLocation() {
        return this.webElement.getLocation();
    }

    public void submit() {
        this.webElement.submit();
    }

    public String getAttribute(String name) {
        return this.webElement.getAttribute(name);
    }

    public String getCssValue(String propertyName) {
        return this.webElement.getCssValue(propertyName);
    }

    public Dimension getSize() {
        return this.webElement.getSize();
    }

    public Rectangle getRect() {
        return this.webElement.getRect();
    }

    public List<WebElement> findElements(By by) {
        return this.webElement.findElements(by);
    }

    public List<WebElementEnhanced> findElementsEnhanced(By by) {
        return this.webElement.findElements(by).stream().map(element -> new WebElementEnhanced((WebElement)element, this.webDriver)).collect(Collectors.toList());
    }

    public String getText() {
        return this.webElement.getText();
    }

    public String getTagName() {
        return this.webElement.getTagName();
    }

    public boolean isSelected() {
        return this.webElement.isSelected();
    }

    public WebElement findElement(By by) {
        return this.webElement.findElement(by);
    }

    public WebElementEnhanced findElementEnhanced(By by) {
        return new WebElementEnhanced(this.webElement.findElement(by), this.webDriver);
    }

    public boolean isEnabled() {
        return this.webElement.isEnabled();
    }

    public boolean isDisplayed() {
        return this.webElement.isDisplayed();
    }

    public void clear() {
        this.webElement.clear();
    }

    public <X> X getScreenshotAs(OutputType<X> outputType) throws WebDriverException {
        return (X)this.webElement.getScreenshotAs(outputType);
    }

    public void waitForDisplayed(int maxWaitTimeInSeconds) {
        WebDriverWait webDriverWait = new WebDriverWait(this.webDriver, (long)maxWaitTimeInSeconds);
        webDriverWait.withMessage("Element: \"" + this.webElement + "\" is still not displayed!");
        webDriverWait.until(driver -> {
            try {
                return this.webElement.isDisplayed();
            }
            catch (WebDriverException e) {
                return false;
            }
        });
    }

    public void scrollTo() {
        if (this.isJQueryAvailable()) {
            this.scrollToWithJQuery();
        } else {
            this.scrollToWithDefaultJavaScript();
        }
    }

    public boolean isJQueryAvailable() {
        return (Boolean)((JavascriptExecutor)this.webDriver).executeScript("return typeof jQuery != 'undefined'", new Object[]{this.webElement});
    }

    public void scrollToWithJQuery() {
        ((JavascriptExecutor)this.webDriver).executeScript("window.scrollTo(0, $(arguments[0]).offset().top - (window.innerHeight / 2))", new Object[]{this.webElement});
        this.waitForDisplayed(1);
    }

    public void scrollToWithDefaultJavaScript() {
        ((JavascriptExecutor)this.webDriver).executeScript("arguments[0].scrollIntoView(false);", new Object[]{this.webElement});
        this.waitForDisplayed(1);
        if (!this.isDisplayed()) {
            ((JavascriptExecutor)this.webDriver).executeScript("window.scrollTo(0, arguments[0]);", new Object[]{this.webElement});
            this.waitForDisplayed(1);
        }
    }

    public void click() {
        this.click(true);
    }

    public void click(boolean scrollTo) {
        if (scrollTo) {
            this.scrollTo();
        }
        new Actions(this.webDriver).click(this.webElement).perform();
    }

    public void setValue(String value) {
        this.clear();
        this.sendKeys(value);
    }

    public boolean exists() {
        return this.check(o -> this.getWebElement());
    }

    public boolean hasChildren(By by) {
        return this.check(o -> this.webElement.findElement(by));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean check(Function check) {
        this.webDriver.manage().timeouts().implicitlyWait(0L, TimeUnit.MILLISECONDS);
        try {
            check.apply(Void.TYPE);
        }
        catch (NoSuchElementException | StaleElementReferenceException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.webDriver.manage().timeouts().implicitlyWait(3L, TimeUnit.SECONDS);
        }
        return true;
    }
}

