/*
 * Decompiled with CFR 0.152.
 */
package de.telekom.test.bddwebapp.api;

import io.restassured.RestAssured;
import io.restassured.config.DecoderConfig;
import io.restassured.config.EncoderConfig;
import io.restassured.config.ObjectMapperConfig;
import io.restassured.config.RestAssuredConfig;
import io.restassured.filter.Filter;
import io.restassured.http.ContentType;
import io.restassured.http.Cookie;
import io.restassured.http.Cookies;
import io.restassured.http.Header;
import io.restassured.http.Headers;
import io.restassured.mapper.ObjectMapper;
import io.restassured.mapper.ObjectMapperType;
import io.restassured.response.Response;
import io.restassured.specification.MultiPartSpecification;
import io.restassured.specification.ProxySpecification;
import io.restassured.specification.RequestSpecification;
import io.restassured.specification.ResponseSpecification;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.security.KeyStore;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RequestBuilder {
    private static final Logger log = LoggerFactory.getLogger(RequestBuilder.class);
    private RestAssuredConfig basicRestConfig = this.defaultConfiguration();
    private RequestSpecification requestSpecification;
    private Response response;

    public RestAssuredConfig defaultConfiguration() {
        return new RestAssuredConfig().decoderConfig(new DecoderConfig("UTF-8")).encoderConfig(new EncoderConfig("UTF-8", "UTF-8")).objectMapperConfig(new ObjectMapperConfig(ObjectMapperType.GSON));
    }

    public void clearRequest() {
        log.debug("Clear request");
        this.requestSpecification = null;
        this.response = null;
    }

    public RequestBuilder request() {
        log.debug("Create new request");
        if (this.requestSpecification == null) {
            this.requestSpecification = ((ResponseSpecification)((RequestSpecification)RestAssured.given().log().all()).expect().log().all()).request();
        }
        return this;
    }

    public RequestBuilder requestWithBaseUriAndProxy(String host, String apiPath, String proxyHost, String proxyPort) {
        this.request();
        this.baseUri(host, apiPath);
        this.proxy(proxyHost, proxyPort);
        return this;
    }

    public RequestBuilder requestWithJsonConfig(String host, String apiPath, String proxyHost, String proxyPort) {
        this.requestWithBaseUriAndProxy(host, apiPath, proxyHost, proxyPort);
        this.restJsonConfig();
        return this;
    }

    public RequestBuilder baseUri(String host, String apiPath) {
        try {
            URI baseURI = new URI(host);
            this.requestSpecification.baseUri(baseURI.toString()).basePath(apiPath);
            int port = baseURI.getPort() > 0 ? baseURI.getPort() : this.determineStandardPortForScheme(baseURI.getScheme());
            this.requestSpecification.port(port);
        }
        catch (Exception ex) {
            throw new RuntimeException("Error setting baseUri for request", ex);
        }
        return this;
    }

    private int determineStandardPortForScheme(String scheme) {
        if (scheme.equalsIgnoreCase("https")) {
            return 443;
        }
        return 80;
    }

    public RequestBuilder proxy(String proxyHost, String proxyPort) {
        try {
            if (StringUtils.isNotBlank((CharSequence)proxyHost) && StringUtils.isNotBlank((CharSequence)proxyPort)) {
                this.requestSpecification.proxy(proxyHost, new Integer(proxyPort).intValue());
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Error setting proxy for request", ex);
        }
        return this;
    }

    public RequestBuilder restJsonConfig() {
        this.requestSpecification.config(this.basicRestConfig);
        this.requestSpecification.header("Accept", (Object)ContentType.JSON.toString(), new Object[0]);
        this.requestSpecification.header("Content-Type", (Object)ContentType.JSON.toString(), new Object[0]);
        return this;
    }

    public RequestSpecification requestSpecification() {
        return this.requestSpecification;
    }

    public Response response() {
        return this.response;
    }

    public void setResponse(Response response) {
        this.response = response;
    }

    public RequestBuilder basePath(String apiPath) {
        this.requestSpecification.basePath(apiPath);
        return this;
    }

    public RequestBuilder basicAuth(String apiUsername, String apiPassword) {
        this.requestSpecification.auth().preemptive().basic(apiUsername, apiPassword);
        return this;
    }

    public RequestBuilder headers(String type, String value) {
        this.requestSpecification.headers(type, (Object)value, new Object[0]);
        return this;
    }

    public RequestBuilder pathParam(String key, String value) {
        this.requestSpecification.pathParam(key, (Object)value);
        return this;
    }

    public RequestBuilder pathParams(Map<String, String> pathParams) {
        this.requestSpecification.pathParams(pathParams);
        return this;
    }

    public RequestBuilder body(String body) {
        this.requestSpecification.body(body);
        return this;
    }

    public RequestBuilder body(Map<String, Object> body) {
        this.requestSpecification.body(body);
        return this;
    }

    public RequestBuilder put() {
        this.response = (Response)this.requestSpecification.put();
        return this;
    }

    public RequestBuilder put(String path) {
        this.response = (Response)this.requestSpecification.put(path, new Object[0]);
        return this;
    }

    public RequestBuilder put(String path, String ... var) {
        this.response = (Response)this.requestSpecification.put(path, (Object[])var);
        return this;
    }

    public RequestBuilder post() {
        this.response = (Response)this.requestSpecification.post();
        return this;
    }

    public RequestBuilder post(String path) {
        this.response = (Response)this.requestSpecification.post(path, new Object[0]);
        return this;
    }

    public RequestBuilder post(String path, String ... var) {
        this.response = (Response)this.requestSpecification.post(path, (Object[])var);
        return this;
    }

    public RequestBuilder get() {
        this.response = (Response)this.requestSpecification.get();
        return this;
    }

    public RequestBuilder get(String path) {
        this.response = (Response)this.requestSpecification.get(path, new Object[0]);
        return this;
    }

    public RequestBuilder get(String path, String ... var) {
        this.response = (Response)this.requestSpecification.get(path, (Object[])var);
        return this;
    }

    public RequestBuilder head() {
        this.response = (Response)this.requestSpecification.head();
        return this;
    }

    public RequestBuilder head(String path) {
        this.response = (Response)this.requestSpecification.head(path, new Object[0]);
        return this;
    }

    public RequestBuilder delete() {
        this.response = (Response)this.requestSpecification.delete();
        return this;
    }

    public RequestBuilder delete(String path) {
        this.response = (Response)this.requestSpecification.delete(path, new Object[0]);
        return this;
    }

    public RequestBuilder delete(String path, String ... var) {
        this.response = (Response)this.requestSpecification.delete(path, (Object[])var);
        return this;
    }

    public RequestBuilder body(byte[] var1) {
        this.requestSpecification.body(var1);
        return this;
    }

    public RequestBuilder body(File var1) {
        this.requestSpecification.body(var1);
        return this;
    }

    public RequestBuilder body(InputStream var1) {
        this.requestSpecification.body(var1);
        return this;
    }

    public RequestBuilder body(Object var1) {
        this.requestSpecification.body(var1);
        return this;
    }

    public RequestBuilder body(Object var1, ObjectMapper var2) {
        this.requestSpecification.body((Object)var2);
        return this;
    }

    public RequestBuilder body(Object var1, ObjectMapperType var2) {
        this.requestSpecification.body(var1, var2);
        return this;
    }

    public RequestBuilder cookies(String var1, Object var2, Object ... var3) {
        this.requestSpecification.cookies(var1, var2, var3);
        return this;
    }

    public RequestBuilder cookies(Map<String, ?> var1) {
        this.requestSpecification.cookies(var1);
        return this;
    }

    public RequestBuilder cookies(Cookies var1) {
        this.requestSpecification.cookies(var1);
        return this;
    }

    public RequestBuilder cookie(String var1, Object var2, Object ... var3) {
        this.requestSpecification.cookie(var1, var2, var3);
        return this;
    }

    public RequestBuilder cookie(String var1) {
        this.requestSpecification.cookie(var1);
        return this;
    }

    public RequestBuilder cookie(Cookie var1) {
        this.requestSpecification.cookie(var1);
        return this;
    }

    public RequestBuilder params(String var1, Object var2, Object ... var3) {
        this.requestSpecification.params(var1, var2, var3);
        return this;
    }

    public RequestBuilder params(Map<String, ?> var1) {
        this.requestSpecification.params(var1);
        return this;
    }

    public RequestBuilder param(String var1, Object ... var2) {
        this.requestSpecification.param(var1, var2);
        return this;
    }

    public RequestBuilder param(String var1, Collection<?> var2) {
        this.requestSpecification.param(var1, var2);
        return this;
    }

    public RequestBuilder queryParams(String var1, Object var2, Object ... var3) {
        this.requestSpecification.queryParams(var1, var2, var3);
        return this;
    }

    public RequestBuilder queryParams(Map<String, ?> var1) {
        this.requestSpecification.queryParams(var1);
        return this;
    }

    public RequestBuilder queryParam(String var1, Object ... var2) {
        this.requestSpecification.queryParam(var1, var2);
        return this;
    }

    public RequestBuilder queryParam(String var1, Collection<?> var2) {
        this.requestSpecification.queryParam(var1, var2);
        return this;
    }

    public RequestBuilder formParams(String var1, Object var2, Object ... var3) {
        this.requestSpecification.formParams(var1, var2, var3);
        return this;
    }

    public RequestBuilder formParams(Map<String, ?> var1) {
        this.requestSpecification.formParams(var1);
        return this;
    }

    public RequestBuilder formParam(String var1, Object ... var2) {
        this.requestSpecification.formParam(var1, var2);
        return this;
    }

    public RequestBuilder formParam(String var1, Collection<?> var2) {
        this.requestSpecification.formParam(var1, var2);
        return this;
    }

    public RequestBuilder pathParam(String var1, Object var2) {
        this.requestSpecification.pathParam(var1, var2);
        return this;
    }

    public RequestBuilder keyStore(String var1, String var2) {
        this.requestSpecification.keyStore(var1, var2);
        return this;
    }

    public RequestBuilder keyStore(File var1, String var2) {
        this.requestSpecification.keyStore(var1, var2);
        return this;
    }

    public RequestBuilder trustStore(String var1, String var2) {
        this.requestSpecification.trustStore(var1, var2);
        return this;
    }

    public RequestBuilder trustStore(File var1, String var2) {
        this.requestSpecification.trustStore(var1, var2);
        return this;
    }

    public RequestBuilder trustStore(KeyStore var1) {
        this.requestSpecification.trustStore(var1);
        return this;
    }

    public RequestBuilder keyStore(KeyStore var1) {
        this.requestSpecification.trustStore(var1);
        return this;
    }

    public RequestBuilder relaxedHTTPSValidation() {
        this.requestSpecification.relaxedHTTPSValidation();
        return this;
    }

    public RequestBuilder relaxedHTTPSValidation(String var1) {
        this.requestSpecification.relaxedHTTPSValidation(var1);
        return this;
    }

    public RequestBuilder headers(String var1, Object var2, Object ... var3) {
        this.requestSpecification.headers(var1, var2, var3);
        return this;
    }

    public RequestBuilder headers(Map<String, ?> var1) {
        this.requestSpecification.headers(var1);
        return this;
    }

    public RequestBuilder headers(Headers var1) {
        this.requestSpecification.headers(var1);
        return this;
    }

    public RequestBuilder header(String var1, Object var2, Object ... var3) {
        this.requestSpecification.header(var1, var2, var3);
        return this;
    }

    public RequestBuilder header(Header var1) {
        this.requestSpecification.header(var1);
        return this;
    }

    public RequestBuilder contentType(ContentType var1) {
        this.requestSpecification.contentType(var1);
        return this;
    }

    public RequestBuilder contentType(String var1) {
        this.requestSpecification.contentType(var1);
        return this;
    }

    public RequestBuilder accept(ContentType var1) {
        this.requestSpecification.accept(var1);
        return this;
    }

    public RequestBuilder accept(String var1) {
        this.requestSpecification.accept(var1);
        return this;
    }

    public RequestBuilder multiPart(MultiPartSpecification var1) {
        this.requestSpecification.multiPart(var1);
        return this;
    }

    public RequestBuilder multiPart(File var1) {
        this.requestSpecification.multiPart(var1);
        return this;
    }

    public RequestBuilder multiPart(String var1, File var2) {
        this.requestSpecification.multiPart(var1, var2);
        return this;
    }

    public RequestBuilder multiPart(String var1, File var2, String var3) {
        this.requestSpecification.multiPart(var1, var2, var3);
        return this;
    }

    public RequestBuilder multiPart(String var1, Object var2) {
        this.requestSpecification.multiPart(var1, var2);
        return this;
    }

    public RequestBuilder multiPart(String var1, Object var2, String var3) {
        this.requestSpecification.multiPart(var1, var2, var3);
        return this;
    }

    public RequestBuilder multiPart(String var1, String var2, Object var3, String var4) {
        this.requestSpecification.multiPart(var1, var2, var3, var4);
        return this;
    }

    public RequestBuilder multiPart(String var1, String var2, byte[] var3) {
        this.requestSpecification.multiPart(var1, var2, var3);
        return this;
    }

    public RequestBuilder multiPart(String var1, String var2, byte[] var3, String var4) {
        this.requestSpecification.multiPart(var1, var2, var3, var4);
        return this;
    }

    public RequestBuilder multiPart(String var1, String var2, InputStream var3) {
        this.requestSpecification.multiPart(var1, var2, var3);
        return this;
    }

    public RequestBuilder multiPart(String var1, String var2, InputStream var3, String var4) {
        this.requestSpecification.multiPart(var1, var2, var3, var4);
        return this;
    }

    public RequestBuilder multiPart(String var1, String var2) {
        this.requestSpecification.multiPart(var1, var2);
        return this;
    }

    public RequestBuilder multiPart(String var1, String var2, String var3) {
        this.requestSpecification.multiPart(var1, var2, var3);
        return this;
    }

    public RequestBuilder port(int var1) {
        this.requestSpecification.port(var1);
        return this;
    }

    public RequestBuilder sessionId(String var1) {
        this.requestSpecification.sessionId(var1);
        return this;
    }

    public RequestBuilder sessionId(String var1, String var2) {
        this.requestSpecification.sessionId(var1, var2);
        return this;
    }

    public RequestBuilder urlEncodingEnabled(boolean var1) {
        this.requestSpecification.urlEncodingEnabled(var1);
        return this;
    }

    public RequestBuilder filter(Filter var1) {
        this.requestSpecification.filter(var1);
        return this;
    }

    public RequestBuilder filters(List<Filter> var1) {
        this.requestSpecification.filters(var1);
        return this;
    }

    public RequestBuilder filters(Filter var1, Filter ... var2) {
        this.requestSpecification.filters(var1, var2);
        return this;
    }

    public RequestBuilder noFilters() {
        this.requestSpecification.noFilters();
        return this;
    }

    public RequestBuilder baseUri(String var1) {
        this.requestSpecification.baseUri(var1);
        return this;
    }

    public RequestBuilder proxy(String var1, int var2) {
        this.requestSpecification.proxy(var1, var2);
        return this;
    }

    public RequestBuilder proxy(String var1) {
        this.requestSpecification.proxy(var1);
        return this;
    }

    public RequestBuilder proxy(int var1) {
        this.requestSpecification.proxy(var1);
        return this;
    }

    public RequestBuilder proxy(String var1, int var2, String var3) {
        this.requestSpecification.proxy(var1, var2, var3);
        return this;
    }

    public RequestBuilder proxy(URI var1) {
        this.requestSpecification.proxy(var1);
        return this;
    }

    public RequestBuilder proxy(ProxySpecification var1) {
        this.requestSpecification.proxy(var1);
        return this;
    }

    public Map<String, Object> getResponseAsMap() {
        try {
            return (Map)this.response.getBody().as(Map.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Error converting rest response to map. Response: [" + this.response.getBody().asString() + "]", e);
        }
    }
}

