/*
 * Copyright (c) 2019 Telekom Deutschland AG
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package de.telekom.smartcredentials.documentscanner.di;

import androidx.annotation.NonNull;

import de.telekom.smartcredentials.core.controllers.CoreController;
import de.telekom.smartcredentials.documentscanner.controllers.DocumentScannerController;

public class ObjectGraphCreatorDocumentScanner {

    private static ObjectGraphCreatorDocumentScanner sInstance;

    private ObjectGraphCreatorDocumentScanner() {
        // required empty constructor
    }

    public static ObjectGraphCreatorDocumentScanner getInstance() {
        if (sInstance == null) {
            sInstance = new ObjectGraphCreatorDocumentScanner();
        }
        return sInstance;
    }

    @NonNull
    public DocumentScannerController provideApiControllerDocumentScanner(CoreController coreController) {
        return new DocumentScannerController(coreController);
    }

    public static void destroy() {
        sInstance = null;
    }
}
